from edps import data_source
from edps.generator.time_range import ONE_DAY, IN_THE_PAST, UNLIMITED, RelativeTimeRange

from .visir_classification import *

# Convention for Data sources Association rule levels:
# Each data source can have several match function which correspond to different
# quality levels for the selected data. The level is specified as a number that
# follows this convention:
#   level < 0: more restrictive than the calibration plan
#   level = 0 follows the calibration plan
#   level = 1 quality sufficient for QC1 certification
#   level = 2 probably still acceptable quality
#   level = 3 significant risk of bad quality results


dit = [kwd.det_seq1_dit, kwd.det_ndit]
setup_sci = [kwd.slit1_wid, kwd.filt2, kwd.ins_resol]
image_setup = dit + [kwd.filt1, kwd.filt2, kwd.ins_pfov, kwd.obs_id, kwd.obs_name, kwd.det_read_curname]
match_image = [kwd.filt1, kwd.ins_pfov]
general_image_setup = dit + [kwd.filt1, kwd.filt2, kwd.ins_pfov, kwd.det_read_curname, kwd.dpr_tech]
# --- Raw files data sources -----------------------------------------------------------------------

# Raw darks
raw_dark = (data_source('DARK')
            .with_classification_rule(dark_img_class)
            .with_classification_rule(dark_spec_class)
            .with_grouping_keywords(dit + [kwd.tpl_start, kwd.dpr_tech])
            .with_setup_keywords(dit + [kwd.det_name])
            .build())

# Standard stars
raw_standard_echelle = (data_source('SPECTROSCOPIC_STANDARDS_ECHELLE')
                        .with_classification_rule(standard_echelle_class)
                        .with_grouping_keywords(setup_sci + [kwd.tpl_start])
                        .with_setup_keywords(setup_sci)
                        .with_match_keywords(setup_sci + [kwd.grat1_wlen, kwd.night],
                                             time_range=RelativeTimeRange(-0.5, 0.5), level=0)
                        .with_match_keywords(setup_sci + [kwd.grat1_wlen, kwd.night],
                                             time_range=ONE_DAY, level=1)

                        .build())

raw_standard_long_slit = (data_source('SPECTROSCOPIC_STANDARDS_LONG_SLIT')
                          .with_classification_rule(standard_spectra_class)
                          .with_grouping_keywords(setup_sci + [kwd.grat1_wlen, kwd.tpl_start])
                          .with_setup_keywords(setup_sci + [kwd.grat1_wlen])
                          .with_match_keywords(setup_sci + [kwd.grat1_wlen, kwd.night],
                                               time_range=RelativeTimeRange(-0.085, 0.085), level=0)
                          .with_match_keywords(setup_sci + [kwd.grat1_wlen, kwd.night], time_range=ONE_DAY, level=1)
                          .build())

raw_standard_image = (data_source('PHOTOMETRIC_STANDARDS')
                      .with_classification_rule(standard_imaging_class)
                      .with_classification_rule(standard_coronagraphy_class)
                      .with_classification_rule(standard_burst_class)
                      .with_grouping_keywords([kwd.dpr_tech, kwd.filt1, kwd.ins_pfov, kwd.tpl_start])
                      .with_setup_keywords(image_setup)
                      .with_match_function(rules.assoc_image, time_range=RelativeTimeRange(-0.125, 0.125), level=0)
                      .with_match_function(rules.assoc_image, time_range=RelativeTimeRange(-90, 90), level=3)
                      .build())

# standard_coronagraphy_class can be either raw_standard_image (to be processed with appropriate recipes) and
# raw_standard_others, to be associated to coronography science stars (which are not processed).
raw_standard_others = (data_source('PHOTOMETRIC_STANDARDS_OTHERS')
                       .with_classification_rule(std_sam_class)
                       .with_classification_rule(std_pupil_class)
                       .with_classification_rule(standard_coronagraphy_class)
                       .with_match_keywords(
    [kwd.dpr_tech + kwd.filt1 + kwd.ins_pfov + kwd.grat1_wlen + kwd.night] + setup_sci,
    time_range=RelativeTimeRange(-0.125, 0.125), level=0)
                       .with_setup_keywords([kwd.dpr_tech, kwd.filt1, kwd.ins_pfov, kwd.grat1_wlen])
                       .build())

# Science frames
raw_science_echelle = (data_source("SCIENCE_ECHELLE")
                       .with_classification_rule(science_echelle_class)
                       .with_grouping_keywords(setup_sci + [kwd.tpl_start])
                       .with_setup_keywords(setup_sci)
                       .build())

raw_science_long_slit = (data_source("SCIENCE_LONG_SLIT")
                         .with_classification_rule(science_long_slit_class)
                         .with_grouping_keywords(setup_sci + [kwd.tpl_start])
                         .with_setup_keywords(setup_sci + [kwd.grat1_wlen])
                         .build())

raw_science_image = (data_source("SCIENCE_IMAGE")
                     .with_classification_rule(science_image_class)
                     .with_classification_rule(science_image_burst_class)
                     .with_classification_rule(science_image_jit_class)
                     .with_classification_rule(science_image_jit_burst_class)
                     .with_setup_keywords(image_setup + [kwd.dpr_tech])
                     .with_grouping_keywords(image_setup + [kwd.tpl_start, kwd.dpr_tech, kwd.obs_targ_name])
                     .build())

raw_sci_coro = (data_source('SCIENCE_CORONAGRAPHY')
                .with_classification_rule(science_coronagraphy_class)
                .with_grouping_keywords([kwd.tpl_start])
                .with_setup_keywords(general_image_setup)
                .build())

raw_sci_sam = (data_source("SCIENCE_SAM")
               .with_classification_rule(science_sam_class)
               .with_setup_keywords(general_image_setup)
               .build())

# --- data sources for static calibrations ---

photometric_catalog = (data_source("PHOTOMETRIC_CATALOG")
                       .with_classification_rule(img_std_catalog_class)
                       .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=0)
                       .build())

spectroscopic_efficiency = (data_source("SPECTROSCOPIC_EFFICIENCY")
                            .with_classification_rule(spec_cal_qeff_class)
                            .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                            .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=1)
                            .build())

telluric_lines = (data_source("TELLURIC_LINES")
                  .with_classification_rule(spec_cal_lines_class)
                  .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                  .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=1)
                  .build())

spectroscopic_catalog = (data_source("SPECTROSCOPIC_CATALOG")
                         .with_classification_rule(spec_std_catalog_class)
                         .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                         .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=1)
                         .build())

static_mask = (data_source()
               .with_classification_rule(static_mask_class)
               .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
               .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=1)
               .build())

linearity_table = (data_source()
                   .with_classification_rule(linearity_table_class)
                   .with_match_keywords([kwd.instrume], time_range=IN_THE_PAST, level=0)
                   .with_match_keywords([kwd.instrume], time_range=UNLIMITED, level=1)
                   .build())

arc_lines_hrg = (data_source()
                 .with_classification_rule(arc_lines_hrg_class)
                 .with_match_keywords([kwd.instrume] + [kwd.slit1_wid, kwd.grat1_wlen, kwd.filt2, kwd.night],
                                      time_range=ONE_DAY, level=0)
                 .build())
