#!/bin/sh

if [ $# -ne 1 ]; then
    echo "Usage: $0 <rbs_rb_working_directory>" >&2
    exit 1
fi

rbs_rb_working_directory=$1
result=0 ;

if [ ! -d ${rbs_rb_working_directory} ]; then
    echo "ERROR: $0: rbs_rb_working_directory=${rbs_rb_working_directory} does not exist or is no directory" >&2
    exit 1
fi

####################
# write QC logfile #
####################

instrument=VISIR
vlt_dictionaries=PRO,ASM,DPR,GEN,IRD,OBS,PRIMARY-FITS,TCS,TPL,VISIR_ICS
paf_files=`find ${rbs_rb_working_directory} -name "*.paf" | xargs -n 1 basename | sort`

for file in ${paf_files}; do
  paf_file=`find ${rbs_rb_working_directory} -name "${file}"`

  ( cd `dirname ${paf_file}`; \
    QC1LogWriter -s VISIR \
                 -I ${DFS_HOME}/data/SYSTEM/Dictionary \
                 -D ${vlt_dictionaries} \
                 -p `basename ${paf_file}` \
  ) >&2
  
  if [ $? -ne 0 ]; then
    echo "ERROR: $0: QC1LogWriter failed on ${paf_file}" >&2
    result=1
    break
  fi
  
done

exit ${result}
