from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport
from adari_core.plots.text import TextPlot
from .visir_utils import VisirSetupInfo
import os

from . import VisirReportMixin

center_size = 200


class VisirMasterDarkReport(VisirReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("visir_dark")

    def parse_sof(self):
        master_dark = None

        for filename, catg in self.inputs:
            if master_dark is None:
                if catg == "IMG_DARK_AVG" or catg == "SPEC_DARK_AVG":
                    master_dark = filename

        # Build and return the file name list
        file_lists = []

        if master_dark is not None:
            file_lists.append({"master_im": master_dark})

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        ext = "PRIMARY"
        vspace = 0.3

        new_panels = super().generate_panels(
            master_im_ext=ext, master_title="Master dark"
        )
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            panel_descr["report_description"] = (
                f"VISIR dark panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{panel_descr['master_im_ext']}"
            )

            master_im = self.hdus[i]["master_im"]

            # Text Plot
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)
            col1 = (
                str(
                    master_im["PRIMARY"].header.get("INSTRUME", "Missing INSTRUME")
                ),
                "EXTNAME: " + str(master_im[ext].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(
                    master_im["PRIMARY"].header.get(
                        "HIERARCH ESO PRO CATG", "Missing PRO CATG"
                    )
                ),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    master_im["PRIMARY"].header.get(
                        "HIERARCH ESO PRO REC1 RAW1 NAME", "Missing RAW1 NAME"
                    )
                ),
            )
            t1.add_data(col1)
            panel.assign_plot(t1, 0, 0, xext=2)

            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = VisirSetupInfo.dark(master_im)
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)


        panels = {**panels, **new_panels}

        return panels


rep = VisirMasterDarkReport()

