from .visir_utils import VisirSetupInfo
from adari_core.data_libs.master_std_star_img import MasterStdStarImg
from adari_core.plots.panel import Panel
from adari_core.plots.text import TextPlot
from adari_core.utils.utils import fetch_kw_or_default

from . import VisirReportMixin


class VisirImgStdReport(VisirReportMixin, MasterStdStarImg):
    center_size = 50
    
    def __init__(self):
        super().__init__("visir_img_std_star")

    def parse_sof(self):

        reduced = None
        # First search for flats
        for filename, catg in self.inputs:
            if catg == "IMG_PHOT_COMBINED" or catg == "IMG_OBJ_COMBINED":
                reduced = filename
        file_lists = []
        if reduced is not None:
            file_lists.append(
                {
                   "calib_std": reduced,
                }
            )

        return file_lists

    def generate_panels(self, **kwargs):
        panels = {}
        vspace = 0.3
        ext = "PRIMARY"
        
        new_panels = super().generate_panels(
            im_ext=ext,
            hist_raw=False,
            hist_n_clipping={"nsigma":1},
        )
            
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            calib_std = self.hdus[i]["calib_std"]
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = VisirSetupInfo.std_img(calib_std)
            t2.add_data(col2)
            panel.assign_plot(t2, 2, 0, xext=1)

        panels = {**panels, **new_panels}

        return panels


rep = VisirImgStdReport()

