from adari_core.data_libs.master_rawdisp import MasterRawdispReport
from .visir_utils import VisirSetupInfo
import astropy.io.fits as fits


import os

from . import VisirReportMixin


class VisirRawdispReport(VisirReportMixin, MasterRawdispReport):
    def __init__(self):
        super().__init__("visir_rawdisp")
        self.extensions = []
        self.tasks = {
            "IM_CAL_DARK" : "dark",
            "SPEC_CAL_DARK": "dark",
            "IM_CAL_PHOT": "std_img",
            "BURST": "std_img",
            "SPEC_CAL_PHOT": "specphot_std",
            "SPEC_CAL_PHOT_HRG": "specphot_std",
        }
        self.setup_info = VisirSetupInfo
        self.data_readers["filename"] = VisirRawdispReport.data_reader

    def parse_sof(self):
        # we building multiple report sets, so we append multiple reports to file_lists
        # get a list of tags
        tags = list(self.tasks.keys())
        file_lists = []
        for filename, catg in self.inputs:
            if catg in tags:
                if filename is not None and len(file_lists) < 1:
                    file_lists.append({"filename": filename})
                    self.sof_tag.append(catg)
                elif filename is not None and "DARK" not in catg and len(file_lists) < 2:
                    file_lists.append({"filename": filename})
                    self.sof_tag.append(catg)
        return file_lists


    def get_extensions(self):
        new_hdus_list = []
        new_sof_tag = []
        for i, filedict in enumerate(self.hdus):
            hdul = filedict["filename"]
            if len(hdul) == 1:
                new_hdus_list.append(filedict)
                new_sof_tag.append(self.sof_tag[i])
                self.extensions.append(0)
            else:
                new_hdus_list.append(filedict)
                new_sof_tag.append(self.sof_tag[i])
                self.extensions.append(len(hdul)-1)
        self.hdus = new_hdus_list
        self.sof_tag = new_sof_tag


    def data_reader(filename):
        hdu = fits.open(filename, mode="readonly")
        for item in hdu.info(output=False):
            if len(item[5]) == 3:
                ext = item[1]
                hdu[ext].data = hdu[ext].data[0]
        return hdu


    def generate_panels(self, **kwargs):
        panels = {}
        self.get_extensions()
        new_panels = super().generate_panels(ext=self.extensions, **kwargs)
        for i, (panel, panel_descr) in enumerate(new_panels.items()):
            # depending on task name
            try:
                task_name = panel_descr["task_name"]
            except KeyError as e:
                raise RuntimeError(
                    "A report has been created by "
                    "MasterRawdispReport that did "
                    "not come back with a task name "
                    "attached!"
                )
            panel_descr["report_name"] = "visir_rawdisp_{}_{}_{}_{}".format(
                task_name,
                self.extensions[i],
                self.sof_tag[i].lower(),
                os.path.basename(panel_descr["filename"]),
            )
            panel_descr["report_description"] = (
                f"VISIR rawdisp panel - "
                f"{panel_descr['task_name']}, "
                f"{panel_descr['tag']}, "
                f"{os.path.basename(panel_descr['filename'])}, "
                f"{panel_descr['ext']}"
            )
        panels = {**panels, **new_panels}

        return panels


rep = VisirRawdispReport()

