from edps import science, qc0, calchecker
from edps import task

from .visir_datasources import *
from .visir_reduce_spectra import process_science_echelle, process_standard_echelle
from .visir_task_functions import standard_optional, standard_mandatory

__title__ = "VISIR echelle workflow"

# --- Reduce echelle observations ------------------------------------------------------------------
# Reduce echelle standard and object
process_echelle_standard = process_standard_echelle(raw_standard_echelle)
process_echelle_science = process_science_echelle(raw_science_echelle)
# These task definitions will be removed in future edps versions, when tasks will be "discovered" also inside classes
repack_ech_std = process_echelle_standard.repack
undistort_ech_std = process_echelle_standard.undistort
destripe_ech_std = process_echelle_standard.destripe
repack_lss_ech = process_echelle_science.repack
undistort_ech_sci = process_echelle_science.undistort
destripe_ech_sci = process_echelle_science.destripe

# Calibrate science echelle observations using echelle standard stars
# Standard stars are mandatory only for QC0 process in Paranal.
calibrate_science_echelle = (task("calibrate_science_echelle")
                             .with_recipe("visir_util_apply_calib")
                             .with_main_input(process_echelle_science.processed)
                             .with_associated_input(process_echelle_standard.processed, [SPC_PHOT_HRG_TAB], min_ret=0,
                                                    condition=standard_optional)
                             .with_associated_input(process_echelle_standard.processed, [SPC_PHOT_HRG_TAB], min_ret=1,
                                                    condition=standard_mandatory)
                             .with_meta_targets([qc0, science, calchecker])
                             .build())
# ---
