# This workflow collects the Sparse Aperture Photometry and Coronographic observation modes,
# which are not supported by the pipeline
__title__ = "VISIR SAM and CORONAGRAPHY"

from edps import qc0, calchecker, subworkflow
from edps import task

from .visir_datasources import *


@subworkflow("coronagraphy_and_sam", "")
def coronagraphy_and_sam(raw_sci_coro, raw_sci_sam, raw_standard_others):
    science_coronagraphy = (task("science_coronagraphy")
                            .with_main_input(raw_sci_coro)
                            .with_associated_input(raw_standard_others)
                            .with_meta_targets([qc0, calchecker])
                            .build())

    science_sam = (task("science_sam")
                   .with_main_input(raw_sci_sam)
                   .with_associated_input(raw_standard_others)
                   .with_meta_targets([qc0, calchecker])
                   .build())

    return science_coronagraphy, science_sam


science_coronagraphy, science_sam = coronagraphy_and_sam(raw_sci_coro, raw_sci_sam, raw_standard_others)
