from edps import ProductRenamer, RecipeInvocationResult, File, JobParameters, get_parameter
from edps import RecipeInputs, RecipeInvocationArguments, InvokerProvider


def run_clip(args: RecipeInvocationArguments, invoker_provider: InvokerProvider,
             renamer: ProductRenamer) -> RecipeInvocationResult:
    # Sort input files in alphabetical order
    sorted_inputs = sorted(args.inputs.combined, key=lambda f: f.name)
    input_files = [File(f.name, f.category, "") for f in sorted_inputs]
    arguments = RecipeInvocationArguments(inputs=RecipeInputs(main_upstream_inputs=input_files),
                                          parameters=args.parameters, job_dir=args.job_dir,
                                          input_map=args.input_map, logging_prefix=args.logging_prefix)

    # Call recipe
    return invoker_provider.recipe_invoker.invoke('visir_util_clip', arguments, renamer, create_subdir=True)


# Functions to determine the condition wether or not the standard star is a mandatory calibration
def standard_optional(params: JobParameters) -> bool:
    return get_parameter(params, "force_standard") == "FALSE"


def standard_mandatory(params: JobParameters) -> bool:
    return get_parameter(params, "force_standard") == 'TRUE'
