//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// COPYRIGHT (c) 1998 European Southern Observatory
// LICENSE
//
// PROJECT:   VLT Data Flow System
// AUTHOR:    Y. Jung - ESO/DMD/DFS
// SUBSYSTEM: Quality Control
// PURPOSE:   Definition of reduction rules for UT3/VISIR
//
//--------------------------------------------------------------------------

instrument: "VISIR" ;
name:		"$Id: visir.dpr,v 1.1.1.1 2007-09-04 09:00:36 llundin Exp $";
version:	"$Revision: 1.1.1.1 $" ;

visir_img_combine(REF_IMAGE) {
    execute visir_img_combine(REF_IMAGE) ;
}

visir_img_phot(REF_IMAGE) {
    if (ref_stdstar_cat=gen_query(REF_IMAGE, DO_CATG=IMG_STD_CATALOG,
    MIN_RET=1, MAX_RET=1))
    execute visir_img_phot(REF_IMAGE, ref_stdstar_cat) ;
}

visir_img_illu(REF_IMAGE) {
    execute visir_img_illu(REF_IMAGE) ;
}

visir_img_psf(REF_IMAGE) {
    execute visir_img_psf(REF_IMAGE) ;
}

visir_img_ff(REF_IMAGE) {
    execute visir_img_ff(REF_IMAGE) ;
}

visir_img_dark(REF_IMAGE) {
    execute visir_img_dark(REF_IMAGE) ;
}

visir_img_pfov(REF_IMAGE) {
    execute visir_img_pfov(REF_IMAGE) ;
}

visir_img_focfwhm(REF_IMAGE) {
    execute visir_img_focfwhm(REF_IMAGE) ;
}

visir_img_trans(REF_IMAGE) {
    execute visir_img_trans(REF_IMAGE) ;
}

visir_img_achro(REF_IMAGE) {
    execute visir_img_achro(REF_IMAGE) ;
}

visir_spc_obs(REF_IMAGE) {
    if (ref_skylines=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_LINES,
        MIN_RET=1, MAX_RET=1) &&
        ref_qeff=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_QEFF,
        MIN_RET=1, MAX_RET=1))
    execute visir_spc_obs(REF_IMAGE, ref_skylines, ref_qeff) ;
}

visir_spc_obs_ech(REF_IMAGE) {
    if (ref_skylines=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_LINES,
        MIN_RET=1, MAX_RET=1) &&
        ref_qeff=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_QEFF,
        MIN_RET=1, MAX_RET=1))
    execute visir_spc_obs_ech(REF_IMAGE, ref_skylines, ref_qeff) ;
}

visir_spc_wcal(REF_IMAGE) {
    if (ref_skylines=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_LINES,
        MIN_RET=1, MAX_RET=1) &&
        ref_qeff=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_QEFF,
        MIN_RET=1, MAX_RET=1))
    execute visir_spc_wcal(REF_IMAGE, ref_skylines, ref_qeff) ;
}

visir_spc_wcal_ech(REF_IMAGE) {
    if (ref_skylines=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_LINES,
        MIN_RET=1, MAX_RET=1) &&
        ref_qeff=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_QEFF,
        MIN_RET=1, MAX_RET=1))
    execute visir_spc_wcal_ech(REF_IMAGE, ref_skylines, ref_qeff) ;
}

visir_spc_phot(REF_IMAGE) {
    if (ref_stdstar_cat=gen_query(REF_IMAGE, DO_CATG=SPEC_STD_CATALOG,
        MIN_RET=1, MAX_RET=1) &&
        ref_skylines=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_LINES,
        MIN_RET=1, MAX_RET=1) &&
        ref_qeff=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_QEFF,
        MIN_RET=1, MAX_RET=1))
    execute visir_spc_phot(REF_IMAGE, ref_stdstar_cat, ref_skylines, ref_qeff) ;
}

visir_spc_phot_ech(REF_IMAGE) {
    if (ref_stdstar_cat=gen_query(REF_IMAGE, DO_CATG=SPEC_STD_CATALOG,
        MIN_RET=1, MAX_RET=1) &&
        ref_skylines=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_LINES,
        MIN_RET=1, MAX_RET=1) &&
        ref_qeff=gen_query(REF_IMAGE, DO_CATG=SPEC_CAL_QEFF,
        MIN_RET=1, MAX_RET=1))
    execute visir_spc_phot_ech(REF_IMAGE, ref_stdstar_cat, ref_skylines, ref_qeff) ;
}

