# VISIR has 3 workflows, one for imaging, one for long-slit, and another for echelle data.
# They are defined in 3 separate files, which are imported here.

from edps import task, qc1calib, ReportInput

from . import visir_echelle_wkf
from . import visir_imaging_wkf
from . import visir_long_slit_wkf
from . import visir_sam_and_coronagraphy_wkf
from .visir_datasources import raw_dark

__title__ = "VISIR workflow"

__all__ = [
    'visir_sam_and_coronagraphy_wkf',
    'visir_imaging_wkf',
    'visir_long_slit_wkf',
    'visir_echelle_wkf',
]

# The dark task is used only for monitoring and it is not used in the data reduction cascade.
# measuring dark current
dark = (task("dark")
        .with_recipe("visir_img_dark")
        .with_report("visir_rawdisp", ReportInput.RECIPE_INPUTS)
        .with_report("visir_dark", ReportInput.RECIPE_INPUTS_OUTPUTS)
        .with_main_input(raw_dark)
        .with_meta_targets([qc1calib])
        .build())
