from adari_core.utils.utils import fetch_kw_or_default

def met1(hdul):
    m = [
        "DET.NDIT: " + str(fetch_kw_or_default(hdul["PRIMARY"], "HIERARCH ESO DET NDIT", default="N/A")), 
        "DET.SEQ1.DIT: " + str(fetch_kw_or_default(hdul["PRIMARY"], "HIERARCH ESO DET SEQ1 DIT", default="N/A")),
    ]
    return m

def met2(hdul):
    m = [
        "INS.FILT1.NAME: " + str(fetch_kw_or_default(hdul["PRIMARY"], "HIERARCH ESO INS FILT1 NAME", default="N/A")), 
        "INS.PFOV: " + str(fetch_kw_or_default(hdul["PRIMARY"], "HIERARCH ESO INS PFOV", default="N/A")),
    ]
    return m



class VisirSetupInfo:
    
    def dark(hdul):
        metadata = met1(hdul)
        return metadata

    def response(hdul):
        metadata = [ ]
        return metadata

    def std_img(hdul):
        metadata = met2(hdul)
        return metadata

    def specphot_std(hdul):
        ins_resol = hdul["PRIMARY"].header.get("HIERARCH ESO INS RESOL", "N/A")
        if str(ins_resol) == "LRP" or str(ins_resol) == "LR":
            metadata = [
                "INS.FILT2.NAME: "
                + str(
                    hdul["PRIMARY"].header.get("HIERARCH ESO INS FILT2 NAME", "N/A")
                ),
                "INS.SLIT1.WID: "
                + str(
                    hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT1 WID", "N/A")
                ),
            ]
        else:
            metadata = [
                "INS.FILT2.NAME: "
                + str(
                    hdul["PRIMARY"].header.get("HIERARCH ESO INS FILT2 NAME", "N/A")
                ),
                "INS.SLIT1.WID: "
                + str(
                    hdul["PRIMARY"].header.get("HIERARCH ESO INS SLIT1 WID", "N/A")
                ),
                "INS.GRAT1.WLEN: "
                + str(
                    hdul["PRIMARY"].header.get("HIERARCH ESO INS GRAT1 WLEN", "N/A")
                ),            
            ]
        return metadata
