from edps import science, qc0, calchecker
from edps import task

from .visir_datasources import *
from .visir_reduce_images import process_standard_images, process_science_images
from .visir_task_functions import standard_optional, standard_mandatory

__title__ = "VISIR imaging workflow"

# --- PROCESSING TASKS -------------------------------------------------------------------

# --- Reduce imaging observations ----------------------------------------------------------------
process_image_standard = process_standard_images(raw_standard_image)
process_image_science = process_science_images(raw_science_image)
# These task definitions will be removed in future edps versions, when tasks will be "discovered" also inside classes
detection_img_sci = process_image_science.detection
clip_img_sci = process_image_science.clip
qc_img_sci = process_image_science.qc
undistort_img_sci = process_image_science.undistort
detection_img_std = process_image_standard.detection
clip_img_std = process_image_standard.clip
qc_img_std = process_image_standard.qc
undistort_img_std = process_image_standard.undistort
photometry_img_Std = process_image_standard.photometry

# Standard stars are mandatory only for QC0 process in Paranal.
calibrate_science_image = (task("calibrate_science_image")
                           .with_recipe("visir_util_apply_calib")
                           .with_main_input(process_image_science.processed)
                           .with_associated_input(process_image_standard.processed, [IMG_PHOT_COMBINED], min_ret=0,
                                                  condition=standard_optional)
                           .with_associated_input(process_image_standard.processed, [IMG_PHOT_COMBINED], min_ret=1,
                                                  condition=standard_mandatory)
                           .with_meta_targets([qc0, science, calchecker])
                           .build())
# ---
