# AREA A1: the import statements
# import statements needed by esoreflex
import reflex
import sys
from argparse import ArgumentParser
import json
import os
import importlib
import json
import copy
import re

# Import statements needed by the 
# algorithm to execute
from astropy.io import fits as fits
import numpy as np

try :
    iu = importlib.import_module('inst_utils')
except ImportError:
    sys.path.insert(0, '%s/instruments' %(os.path.dirname(__file__)))
    iu = importlib.import_module('inst_utils')
except Exception as e:
    raise(e)

# END OF AREA A1
# AREA A2: the algorithm(s).
# END OF AREA A2
# AREA A3: the interface.
# This is the main Phython script. It contains 2 general parts and a
# customized part, that is responsible of calling the desired
# reduction function.
# ------------------------------------------------------------------------------------------
def do_stuff():
    return
# ------------------------------------------------------------------------------------------
if __name__ == '__main__':

    # ***  PART P1: Input/output ports ***

    #Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("-i", "--in_sof", dest="in_sof")
    parser.add_option("-p", "--in_sop", dest="in_sop")

    #parser.add_output("-o", "--out_sop", dest="out_sop")
    parser.add_output("-q", "--out_sof", dest="out_sof")

    inputs = parser.get_inputs()
    outputs = parser.get_outputs()
    in_sof = inputs.in_sof
    files = in_sof.files

    #Define the list of outputs
    output_files=list()
    output_datasetname=in_sof.datasetName

    #Get the name of the output directory
    pattern = '^--products-dir='
    for arg in sys.argv:
        m=re.match(pattern, arg)
        if m is not None :
            output_dir = re.sub(pattern, '', arg)

    # ***  END OF PART P1 ***

    # ***  PART P2: customized part***

    files_dict={}
    for file in files:
        if file.category not in files_dict.keys() :
            # write the first file of each category to files_dict
            # In the case where there would be multiple SCIENCE
            # molecfit_model would anyway only use the first one...
            files_dict[file.category]=file
    ## molecfit_model only works on a single file, so we only bother normalizing
    ## the one the molecfit_model would select, and it selects in order the first file
    ## it finds in the SOF of STD_MODEL then SCIENCE_CALCTRANS then SCIENCE.
    propagate_keys_from_list=[None,]
    propagate_BFP_from=None # not used any more since we simply add BFP to final product...
    valid_categories=[]
    append_hdulist=[]
    append_hdulist_header=[]
    recipe=''
    if len(inputs.in_sop) > 0 :
        recipe=inputs.in_sop[0].recipe

    # this will modify the category of any file with the category=key to category=value
    # if categore not in keys() category is left unchanged
    ## We need this because in 4.2, moelcfit_correct is not acceptinf a SOF
    ## with zero SCIENCE file (i.e with SCIENCE_CALCTRANS only)
    ## But in some future version this should be fixed... PIPE-.....
    modify_category={}
    rec_prefixs={
        'xsh': "xsh_",
    }
    valid_categories_list_by_recipe={
        'xsh_molecfit_model':     ["SCI_SLIT_FLUX_IDP_VIS","SCI_SLIT_FLUX_IDP_NIR","TELL_SLIT_FLUX_IDP_VIS","TELL_SLIT_FLUX_IDP_NIR"],
        'xsh_molecfit_calctrans': ["SCI_SLIT_FLUX_IDP_VIS","SCI_SLIT_FLUX_IDP_NIR","TELL_SLIT_FLUX_IDP_VIS","TELL_SLIT_FLUX_IDP_NIR"],
        'xsh_molecfit_correct':   ["SCI_SLIT_FLUX_IDP_VIS","SCI_SLIT_FLUX_IDP_NIR","TELL_SLIT_FLUX_IDP_VIS","TELL_SLIT_FLUX_IDP_NIR"],
    }
    ### Untested
    ## ToDo: Make this work...
    propagate_keys_from_list_by_recipe={
        'xsh_molecfit_calctrans': ["BEST_FIT_PARAMETERS_STD_VIS","BEST_FIT_PARAMETERS_STD_NIR","BEST_FIT_PARAMETERS_SCI_VIS","BEST_FIT_PARAMETERS_SCI_NIR"],
        'xsh_molecfit_correct':   ["TELLURIC_CORR_STD_VIS","TELLURIC_CORR_STD_NIR","TELLURIC_CORR_SCI_VIS","TELLURIC_CORR_SCI_NIR"],
    }

    rec_prefix=rec_prefixs.get(recipe[0:recipe.index('_')],'')
    nfiles=None
    if recipe in ['molecfit_model','xsh_molecfit_model',] :
        valid_categories=valid_categories_list_by_recipe.get(recipe,['SCIENCE','SCIENCE_CALCTRANS','STD_MODEL',])
    elif recipe in ['molecfit_calctrans','xsh_molecfit_calctrans',] :
        valid_categories=valid_categories_list_by_recipe.get(recipe,['SCIENCE','SCIENCE_CALCTRANS',])
        # Propagate keys from molecfit_model
        propagate_keys_from_list=propagate_keys_from_list_by_recipe.get(recipe,["BEST_FIT_PARAMETERS",])
        propagate_keys_from_recipes=[rec_prefix+"molecfit_model",]
    elif recipe in ['molecfit_correct','xsh_molecfit_correct',] :
        nfiles=files
        valid_categories=valid_categories_list_by_recipe.get(recipe,['SCIENCE','SCIENCE_CALCTRANS',])
        # Propagate keys from molecfit_calctrans
        propagate_keys_from_list=propagate_keys_from_list_by_recipe.get(recipe,["TELLURIC_CORR",])
        propagate_keys_from_recipes=[rec_prefix+"molecfit_model",rec_prefix+"molecfit_calctrans",]
        modify_category['SCIENCE_CALCTRANS']='SCIENCE'
    if nfiles is None :
        for vc in valid_categories :
            if vc in files_dict.keys() :
                nfiles=[files_dict[vc]]
    pkfl=[]
    for propagate_keys_from in propagate_keys_from_list :
        if propagate_keys_from is not None and propagate_keys_from in files_dict.keys() :
            pkfl+=[propagate_keys_from,]

    if nfiles is not None :
        pkf_str=[]
        for propagate_keys_from in pkfl :
            pkf_str+=[("Propagating %s PRO.REC keys in %s"
                %(",".join(propagate_keys_from_recipes),files_dict[propagate_keys_from].name)
            ),]
            pkf=fits.open(files_dict[propagate_keys_from].name)
            # Find the keys for the recipe we need to propagate for...
            hdr=fits.Header()
            for pkf_recipe in propagate_keys_from_recipes :
                match_str=None
                for k in pkf[0].header :
                    if (
                        re.match('ESO PRO REC[0-9]? ID',k)
                        and
                        pkf[0].header[k].strip() == pkf_recipe
                    ) :
                        match_str=re.sub(' ID','',k)
                if match_str is not None :
                    for k in pkf[0].header :
                        if re.match(match_str,k) :
                            hdr.set('HIERARCH %s' %k,pkf[0].header[k],pkf[0].header.comments[k])
            pkf.close()
        if propagate_BFP_from is not None and propagate_BFP_from in files_dict.keys() :
            # not used any more since we simply add BFP to final product...
            for propagate_keys_from in pkfl :
                print("Propagating %s DRS.MF.PARAM keys to %s"
                    %(",".join(propagate_keys_from_recipes),file.name)
                )
                p_BFP_f=fits.open(files_dict[propagate_keys_from].name)
                append_hdulist+=[p_BFP_f[1],]
                # Find the keys for the recipe we need to propagate for...
                append_hdulist_header+=[fits.Header(),]
                match_str=None
                #append_hdulist_header[-1]['NAXIS1']=p_BFP_f[1].header['NAXIS1']
                #append_hdulist_header[-1]['NAXIS2']=p_BFP_f[1].header['NAXIS2']
                for k in p_BFP_f[0].header :
                    if (
                        re.match('ESO DRS MF PARAM',k)
                    ) :
                        append_hdulist_header[-1].set('HIERARCH %s' %k,p_BFP_f[0].header[k],p_BFP_f[0].header.comments[k])
        for file in nfiles:
            out_file_name=file.name
            if file.category in valid_categories :
                hdulist=fits.open(file.name)
                for i,propagate_keys_from in enumerate(pkfl) :
                    if propagate_keys_from is not None and propagate_keys_from in files_dict.keys() :
                        out_file_name="%s/%s" %(output_dir,os.path.basename(file.name))
                        print("%s to %s" %(pkf_str[i],out_file_name))
                        for k in hdr :
                            hdulist[0].header.set('HIERARCH %s' %k,hdr[k],hdr.comments[k])
                        iu.HDUList(hdulist).writeto(
                            out_file_name, overwrite=True, checksum=True, output_verify='silentfix'
                        )
                output_files.append(
                    reflex.FitsFile(
                        out_file_name,
                        modify_category.get(file.category,file.category),
                        hdulist[0].header.get('CHECKSUM'),
                        file.purposes
                    )
                )
                hdulist.close()
        for file in files:
            if file.category not in valid_categories :
                hdulist=fits.open(file.name)
                output_files.append(
                    reflex.FitsFile(
                        file.name,
                        file.category,
                        hdulist[0].header.get('CHECKSUM'),
                        file.purposes
                    )
                )
                hdulist.close()
    else :
        output_files=files
    # *** END OF PART P2***

    # *** PART P3: broadcast products ***
  
    # After the script is completed, the list of products is
    # broadcasted to the output sof.
    new_sof = reflex.SetOfFiles(output_datasetname,output_files)
    outputs.out_sof = new_sof    

    # Broadcast outputs on the extra output port.
    # broadcast outputs:
    parser.write_outputs()
    sys.exit()
    # ***  END OF PART P3 ***
    # ***  END OF AREA A3***    
