# AREA A1: the import statements
# import statements needed by esoreflex
import reflex
import sys
from argparse import ArgumentParser
import json
import os
import importlib
import json
import copy
import re

# Import statements needed by the 
# algorithm to execute
from astropy.io import fits as fits
import numpy as np

#force_include_H2O=True
force_include_H2O=False

# END OF AREA A1
# AREA A2: the algorithm(s).
# END OF AREA A2
# AREA A3: the interface.
# This is the main Python script. It contains 2 general parts and a
# customized part, that is responsible of calling the desired
# reduction function.
# ------------------------------------------------------------------------------------------
def sop_force_include_H2O( in_sop ) :
    out_sop=in_sop
    sop_keynames=[rp.name for rp in in_sop]
    if force_include_H2O and 'LIST_MOLEC' in sop_keynames :
        if 'H2O' not in out_sop[sop_keynames.index('LIST_MOLEC')].value :
            out_sop[sop_keynames.index('LIST_MOLEC')].value+=",H2O"
            out_sop[sop_keynames.index('FIT_MOLEC')].value+=",0"
            out_sop[sop_keynames.index('REL_COL')].value+=",1.0"
    return out_sop
# ------------------------------------------------------------------------------------------
if __name__ == '__main__':

    # ***  PART P1: Input/output ports ***

    #Define inputs/outputs
    parser = reflex.ReflexIOParser()
    parser.add_option("--in_sop", dest="in_sop")

    parser.add_output("--out_sop", dest="out_sop")

    inputs = parser.get_inputs()
    outputs = parser.get_outputs()

    # ***  END OF PART P1 ***

    # ***  PART P2: customized part***
    # *** END OF PART P2***

    # *** PART P3: broadcast products ***
  
    # After the script is completed, the list of products is
    # broadcasted to the output sop.
    outputs.out_sop=sop_force_include_H2O( inputs.in_sop )

    # Broadcast outputs on the extra output port.
    # broadcast outputs:
    parser.write_outputs()
    sys.exit()
    # ***  END OF PART P3 ***
    # ***  END OF AREA A3***    
