from .xshooter_utils import XshooterSetupInfo
from .xshooter_utils import get_arm
from adari_core.data_libs.master_detmon import MasterDetmonReport
from adari_core.plots.combined import CombinedPlot
from adari_core.plots.cut import CutPlot
from adari_core.plots.histogram import HistogramPlot
from adari_core.plots.images import ImagePlot
from adari_core.plots.panel import Panel
from adari_core.plots.points import LinePlot, ScatterPlot
from adari_core.plots.text import TextPlot

from adari_core.utils.utils import fetch_kw_or_default
import numpy as np
import os
import re
import warnings
import astropy.io.fits as fits


class XshooterDetmonReport(MasterDetmonReport):
    files_needed = {
        "on": "ON_RAW",
        "off": "OFF_RAW",
        "gain_info": "GAIN_INFO",
        "detlin_info": "DET_LIN_INFO",
        "coeffs_cube": "COEFFS_CUBE",
    }
    center_size = 200

    def __init__(self):
        super().__init__("xshooter_detmon", self.files_needed)

    def access_port(self, im_hdu, port):
        return im_hdu

    def generate_panels(self, **kwargs):
        panels = {}

        arm = get_arm(self.hdus[0]['on000'][0])
        
        # Setup for master report
        data_info = {}
        if "NIR" not in arm:
            data_info["exptime_key"] = "EXPTIME"
            data_info["gain_nominal_key"] = "HIERARCH ESO DET OUT1 CONAD"
            data_info["lintime_key"] = "EXPTIME"
        else:
            data_info["exptime_key"] = "HIERARCH ESO DET DIT"
            data_info["gain_nominal_key"] = "HIERARCH ESO DET CHIP GAIN"
            data_info["lintime_key"] = "DIT"


        new_panels = super().generate_panels(
                data_info=data_info,
                ext="PRIMARY",
                port=1,
            )

        for panel, panel_descr in new_panels.items():

            # Metadata
            metadata = XshooterSetupInfo.detmon(list(self.hdus[0].values())[0])
            text2 = TextPlot(v_space=self.METADATA_V_SPACING)
            text2.add_data(metadata)
            panel.assign_plot(text2, 1, 0)

        panels = {**panels, **new_panels}

        return panels



rep = XshooterDetmonReport()


