from adari_core.data_libs.master_raw_cuts import MasterRawCutsReport
from .xshooter_utils import strip_prescan_overscan
from .xshooter_utils import XshooterSetupInfo

from adari_core.plots.text import TextPlot

# from adari_core.data_libs.master_raw_cuts import Panel
from astropy.io import fits

import os

from . import XshooterReportMixin

center_size = 200


class XshooterMasterBiasReport(XshooterReportMixin, MasterRawCutsReport):
    def __init__(self):
        super().__init__("xshooter_master_bias")
        self.center_size = center_size

    def remove_raw_scan(self, im_hdu, **kwargs):
        return strip_prescan_overscan(im_hdu, debug=True, **kwargs)

    def parse_sof(self):

        master_bias_vis = None
        master_bias_uvb = None
        master_bias_agc = None
        first_raw_vis = None
        first_raw_uvb = None
        first_raw_agc = None
        
        for filename, catg in self.inputs:
            if catg == "MASTER_BIAS_VIS" and master_bias_vis is None:
                master_bias_vis = filename
            elif catg == "MASTER_BIAS_UVB" and master_bias_uvb is None:
                master_bias_uvb = filename
            elif catg == "MASTER_BIAS_AGC" and master_bias_agc is None:
                master_bias_agc = filename
            elif catg == "BIAS_VIS" and first_raw_vis is None:
                first_raw_vis = filename
            elif catg == "BIAS_UVB" and first_raw_uvb is None:
                first_raw_uvb = filename
            elif catg == "BIAS_AGC" and first_raw_agc is None:
                first_raw_agc = filename
        
        
        # Build and return the file name list
        file_lists = []
        if first_raw_vis is not None:
            if master_bias_vis is not None:
                file_lists.append(
                    {
                        "master_im": master_bias_vis,
                        "raw_im": first_raw_vis,
                    }
                )
        elif first_raw_uvb is not None:
            if master_bias_uvb is not None:
                file_lists.append(
                    {
                        "master_im": master_bias_uvb,
                        "raw_im": first_raw_uvb,
                    }
                )
        elif first_raw_agc is not None:
            if master_bias_agc is not None:
                file_lists.append(
                    {
                        "master_im": master_bias_agc,
                        "raw_im": first_raw_agc,
                    }
                )        
        return file_lists

    def generate_panels(self, **kwargs):
        if len(self.hdus[0]["raw_im"]) == 1:  # Blue raw bias is single ext
            exts = "PRIMARY"
        else:
            exts = []

        new_panels = super().generate_panels(
            raw_im_ext=exts,
            raw_title="First raw",
            master_im_ext="PRIMARY",
            master_title="Master bias",
        )
        for panel, panel_descr in new_panels.items():
            panel_descr["report_description"] = (
                f"XSHOOTER bias panel - "
                f"{os.path.basename(panel_descr['master_im'])}, "
                f"{os.path.basename(panel_descr['raw'])}, "
                f"{os.path.basename(panel_descr['master_procatg'])}, "
                f"{panel_descr['master_im_ext']}"
            )

            master_im = fits.open(panel_descr["master_im"])
            raw_im = fits.open(panel_descr["raw"])
            raw_im_ext = panel_descr["raw_im_ext"]
            # Text Plot
            px = 0
            py = 0
            # which hdul and ext to use
            vspace = 0.3
            fname = os.path.basename(str(master_im.filename()))
            t1 = TextPlot(columns=1, v_space=vspace)

            col1 = (
                str(master_im["PRIMARY"].header.get("INSTRUME")),
                "EXTNAME: " + str(raw_im[raw_im_ext].header.get("EXTNAME", "N/A")),
                "PRO CATG: "
                + str(master_im["PRIMARY"].header.get("HIERARCH ESO PRO CATG")),
                "FILE NAME: " + fname,
                "RAW1 NAME: "
                + str(
                    master_im["PRIMARY"].header.get("HIERARCH ESO PRO REC1 RAW1 NAME")
                ),
            )
            t1.add_data(col1)

            panel.assign_plot(t1, px, py, xext=2)

            px = px + 2
            t2 = TextPlot(columns=1, v_space=vspace, xext=1)
            col2 = XshooterSetupInfo.bias(master_im)
            t2.add_data(col2)
            panel.assign_plot(t2, px, py, xext=1)

            hist = panel.retrieve(4, 1)
            hist.bins = 15

        return new_panels


rep = XshooterMasterBiasReport()
