from edps import classification_rule

from . import xshooter_keywords as kwd
from . import xshooter_rules as rules

# ---------------- CLASSIFICATION RULES -----------------

# ---------------- RAW DATA -----------------------------

linearity_detmon_on_uvb_class = classification_rule('ON_RAW', rules.is_linearity_on_uvb)
linearity_detmon_off_uvb_class = classification_rule('OFF_RAW', rules.is_linearity_off_uvb)
linearity_detmon_on_vis_class = classification_rule('ON_RAW', rules.is_linearity_on_vis)
linearity_detmon_off_vis_class = classification_rule('OFF_RAW', rules.is_linearity_off_vis)
linearity_detmon_on_nir_class = classification_rule('ON_RAW', rules.is_linearity_on_nir)
linearity_detmon_off_nir_class = classification_rule('OFF_RAW', rules.is_linearity_off_nir)
linearity_detmon_on_agc_class = classification_rule('ON_RAW', rules.is_linearity_on_agc)
linearity_detmon_off_agc_class = classification_rule('OFF_RAW', rules.is_linearity_off_agc)

bias_uvb_class = classification_rule('BIAS_UVB', rules.is_bias_uvb)
bias_vis_class = classification_rule('BIAS_VIS', rules.is_bias_vis)
bias_agc_class = classification_rule('BIAS_AGC', rules.is_bias_agc)

dark_uvb_class = classification_rule('DARK_UVB', rules.is_dark_uvb)
dark_vis_class = classification_rule('DARK_VIS', rules.is_dark_vis)
dark_nir_class = classification_rule('DARK_NIR', rules.is_dark_nir)
dark_agc_class = classification_rule('DARK_AGC', rules.is_dark_agc)

fmtchk_uvb_class = classification_rule('FMTCHK_UVB', rules.is_fmtchk_uvb)
fmtchk_vis_class = classification_rule('FMTCHK_VIS', rules.is_fmtchk_vis)
fmtchk_nir_on_class = classification_rule('FMTCHK_NIR_ON', rules.is_fmtchk_on_nir)
fmtchk_nir_off_class = classification_rule('FMTCHK_NIR_OFF', rules.is_fmtchk_off_nir)

orderdef_uvb_class = classification_rule('ORDERDEF_D2_UVB', rules.is_dorderdef_uvb)
orderdef_uvb_qth_class = classification_rule('ORDERDEF_QTH_UVB', rules.is_qorderdef_uvb)
orderdef_vis_class = classification_rule('ORDERDEF_VIS', rules.is_orderdef_vis)
orderdef_nir_class = classification_rule('ORDERDEF_NIR_ON', rules.is_orderdef_nir)
orderdef_nir_off_class = classification_rule('ORDERDEF_NIR_OFF', rules.is_orderdef_nir_off)

flat_d2_slit_uvb_class = classification_rule('FLAT_D2_SLIT_UVB', rules.is_flat_d2_slit_uvb)
flat_qth_slit_uvb_class = classification_rule('FLAT_QTH_SLIT_UVB', rules.is_flat_qth_slit_uvb)
flat_slit_vis_class = classification_rule('FLAT_SLIT_VIS', rules.is_flat_slit_vis)
flat_slit_nir_on_class = classification_rule('FLAT_SLIT_NIR_ON', rules.is_flat_slit_nir_on)
flat_slit_nir_off_class = classification_rule('FLAT_SLIT_NIR_OFF', rules.is_flat_slit_nir_off)
flat_d2_ifu_uvb_class = classification_rule('FLAT_D2_IFU_UVB', rules.is_flat_d2_ifu_uvb)
flat_qth_ifu_uvb_class = classification_rule('FLAT_QTH_IFU_UVB', rules.is_flat_qth_ifu_uvb)

flat_ifu_vis_class = classification_rule('FLAT_IFU_VIS', rules.is_flat_ifu_vis)
flat_ifu_nir_on_class = classification_rule('FLAT_IFU_NIR_ON', rules.is_flat_ifu_nir_on)
flat_ifu_nir_off_class = classification_rule('FLAT_IFU_NIR_OFF', rules.is_flat_ifu_nir_off)
# HC flats are not used in the reduction, but I might still want to classify them
flat_qth_ifu_uvb_hc_class = classification_rule('FLAT_QTH_IFU_UVB', rules.is_flat_qth_ifu_uvb_hc)
flat_d2_ifu_uvb_hc_class = classification_rule('FLAT_D2_IFU_UVB', rules.is_flat_d2_ifu_uvb_hc)
flat_ifu_vis_hc_class = classification_rule('FLAT_IFU_VIS', rules.is_flat_ifu_vis_hc)
flat_ifu_nir_on_hc_class = classification_rule('FLAT_IFU_NIR_ON', rules.is_flat_ifu_nir_on_hc)
flat_ifu_nir_off_hc_class = classification_rule('FLAT_IFU_NIR_OFF', rules.is_flat_ifu_nir_off_hc)
skyflat_agc_class = classification_rule("SKYFLAT_AGC", rules.is_skyflat_agc)
wave_uvb_class = classification_rule('WAVE_UVB', rules.is_wave_uvb)
wave_vis_class = classification_rule('WAVE_VIS', rules.is_wave_vis)
wave_nir_on_class = classification_rule('WAVE_NIR_ON', rules.is_wave_nir_on)
wave_nir_off_class = classification_rule('WAVE_NIR_OFF', rules.is_wave_nir_off)

# IFU wave have the same tag as slit
# wave_uvb_ifu_class = classification_rule('WAVE_UVB', rules.is_wave_uvb_ifu)
# wave_vis_ifu_class = classification_rule('WAVE_VIS', rules.is_wave_vis_ifu)
# wave_nir_ifu_on_class = classification_rule('WAVE_NIR_ON', rules.is_wave_nir_on_ifu)
# wave_nir_ifu_off_class = classification_rule('WAVE_NIR_OFF', rules.is_wave_nir_off_ifu)

arc_slit_uvb_class = classification_rule('ARC_SLIT_UVB', rules.is_arc_slit_uvb)
arc_slit_vis_class = classification_rule('ARC_SLIT_VIS', rules.is_arc_slit_vis)
arc_slit_nir_on_class = classification_rule('ARC_SLIT_NIR_ON', rules.is_arc_slit_nir_on)
arc_slit_nir_off_class = classification_rule('ARC_SLIT_NIR_OFF', rules.is_arc_slit_nir_off)
arc_ifu_uvb_class = classification_rule('ARC_IFU_UVB', rules.is_arc_ifu_uvb)
arc_ifu_vis_class = classification_rule('ARC_IFU_VIS', rules.is_arc_ifu_vis)
arc_ifu_nir_on_class = classification_rule('ARC_IFU_NIR_ON', rules.is_arc_ifu_nir_on)
arc_ifu_nir_off_class = classification_rule('ARC_IFU_NIR_OFF', rules.is_arc_ifu_nir_off)
adc_slit_uvb = classification_rule("ADC_SLIT_UVB", rules.is_adc_slit_uvb)
adc_slit_vis = classification_rule("ADC_SLIT_VIS", rules.is_adc_slit_vis)
adc_slit_nir = classification_rule("ADC_SLIT_NIR", rules.is_adc_slit_nir)
# afc_slit_uvb = classification_rule("AFC_SLIT_UVB", rules.is_afc_slit_uvb)
# afc_slit_vis = classification_rule("AFC_SLIT_VIS", rules.is_afc_slit_vis)
# afc_slit_nir = classification_rule("AFC_SLIT_NIR", rules.is_afc_slit_nir)
afc_ifu_uvb = classification_rule("AFC_IFU_UVB", rules.is_afc_ifu_uvb)
afc_ifu_vis = classification_rule("AFC_IFU_VIS", rules.is_afc_ifu_vis)
afc_ifu_nir = classification_rule("AFC_IFU_NIR", rules.is_afc_ifu_nir)
afc_generic_uvb = classification_rule("AFC_GENERIC_UVB", rules.is_afc_generic_uvb)
afc_generic_vis = classification_rule("AFC_GENERIC_VIS", rules.is_afc_generic_vis)
afc_generic_nir = classification_rule("AFC_GENERIC_NIR", rules.is_afc_generic_nir)

flex_slit_uvb_class = classification_rule('AFC_ATT_UVB', rules.is_flex_slit_uvb)
flex_slit_vis_class = classification_rule('AFC_ATT_VIS', rules.is_flex_slit_vis)
flex_slit_nir_class = classification_rule('AFC_ATT_NIR', rules.is_flex_slit_nir)
flex_ifu_uvb_class = classification_rule('AFC_ATT_UVB', rules.is_flex_ifu_uvb)
flex_ifu_vis_class = classification_rule('AFC_ATT_VIS', rules.is_flex_ifu_vis)
flex_ifu_nir_class = classification_rule('AFC_ATT_NIR', rules.is_flex_ifu_nir)

raw_std_slit_off_uvb_class = classification_rule('STD_FLUX_SLIT_OFFSET_UVB', rules.is_std_flux_slit_off_uvb)
raw_std_slit_off_vis_class = classification_rule('STD_FLUX_SLIT_OFFSET_VIS', rules.is_std_flux_slit_off_vis)
raw_std_slit_off_nir_class = classification_rule('STD_FLUX_SLIT_OFFSET_NIR', rules.is_std_flux_slit_off_nir)

sky_flux_slit_off_uvb_class = classification_rule('SKY_SLIT_UVB', rules.is_sky_flux_slit_off_uvb)
sky_flux_slit_off_vis_class = classification_rule('SKY_SLIT_VIS', rules.is_sky_flux_slit_off_vis)
sky_flux_slit_off_nir_class = classification_rule('SKY_SLIT_NIR', rules.is_sky_flux_slit_off_nir)

raw_std_slit_nod_uvb_class = classification_rule('STD_FLUX_SLIT_NOD_UVB', rules.is_std_flux_slit_nod_uvb)
raw_std_slit_nod_vis_class = classification_rule('STD_FLUX_SLIT_NOD_VIS', rules.is_std_flux_slit_nod_vis)
raw_std_slit_nod_nir_class = classification_rule('STD_FLUX_SLIT_NOD_NIR', rules.is_std_flux_slit_nod_nir)

raw_std_slit_stare_uvb_class = classification_rule('STD_FLUX_SLIT_STARE_UVB', rules.is_std_flux_slit_stare_uvb)
raw_std_slit_stare_vis_class = classification_rule('STD_FLUX_SLIT_STARE_VIS', rules.is_std_flux_slit_stare_vis)
raw_std_slit_stare_nir_class = classification_rule('STD_FLUX_SLIT_STARE_NIR', rules.is_std_flux_slit_stare_nir)

# IFU STANDARD STARS ARE TREATED AS SCIENCE TARGETS
raw_std_ifu_off_uvb_class = classification_rule('OBJECT_IFU_OFFSET_UVB', rules.is_std_flux_ifu_off_uvb)
raw_std_ifu_off_vis_class = classification_rule('OBJECT_IFU_OFFSET_VIS', rules.is_std_flux_ifu_off_vis)
raw_std_ifu_off_nir_class = classification_rule('OBJECT_IFU_OFFSET_NIR', rules.is_std_flux_ifu_off_nir)

sky_flux_ifu_off_uvb_class = classification_rule('SKY_IFU_UVB', rules.is_sky_flux_ifu_off_uvb)
sky_flux_ifu_off_vis_class = classification_rule('SKY_IFU_VIS', rules.is_sky_flux_ifu_off_vis)
sky_flux_ifu_off_nir_class = classification_rule('SKY_IFU_NIR', rules.is_sky_flux_ifu_off_nir)

raw_std_ifu_nod_uvb_class = classification_rule('OBJECT_IFU_NOD_UVB', rules.is_std_flux_ifu_nod_uvb)
raw_std_ifu_nod_vis_class = classification_rule('OBJECT_IFU_NOD_VIS', rules.is_std_flux_ifu_nod_vis)
raw_std_ifu_nod_nir_class = classification_rule('OBJECT_IFU_NOD_NIR', rules.is_std_flux_ifu_nod_nir)

raw_std_ifu_stare_uvb_class = classification_rule('OBJECT_IFU_STARE_UVB', rules.is_std_flux_ifu_stare_uvb)
raw_std_ifu_stare_vis_class = classification_rule('OBJECT_IFU_STARE_VIS', rules.is_std_flux_ifu_stare_vis)
raw_std_ifu_stare_nir_class = classification_rule('OBJECT_IFU_STARE_NIR', rules.is_std_flux_ifu_stare_nir)

raw_tell_slit_stare_uvb_class = classification_rule('STD_TELL_SLIT_STARE_UVB', rules.is_std_tell_slit_stare_uvb)
raw_tell_slit_stare_vis_class = classification_rule('STD_TELL_SLIT_STARE_VIS', rules.is_std_tell_slit_stare_vis)
raw_tell_slit_stare_nir_class = classification_rule('STD_TELL_SLIT_STARE_NIR', rules.is_std_tell_slit_stare_nir)
raw_tell_slit_offset_uvb_class = classification_rule('STD_TELL_SLIT_OFFSET_UVB', rules.is_std_tell_slit_offset_uvb)
raw_tell_slit_offset_vis_class = classification_rule('STD_TELL_SLIT_OFFSET_VIS', rules.is_std_tell_slit_offset_vis)
raw_tell_slit_offset_nir_class = classification_rule('STD_TELL_SLIT_OFFSET_NIR', rules.is_std_tell_slit_offset_nir)

raw_tell_slit_nod_uvb_class = classification_rule('STD_TELL_SLIT_NOD_UVB', rules.is_std_tell_slit_nod_uvb)
raw_tell_slit_nod_vis_class = classification_rule('STD_TELL_SLIT_NOD_VIS', rules.is_std_tell_slit_nod_vis)
raw_tell_slit_nod_nir_class = classification_rule('STD_TELL_SLIT_NOD_NIR', rules.is_std_tell_slit_nod_nir)

raw_sci_slit_stare_uvb_class = classification_rule('OBJECT_SLIT_STARE_UVB', rules.is_sci_slit_stare_uvb)
raw_sci_slit_stare_vis_class = classification_rule('OBJECT_SLIT_STARE_VIS', rules.is_sci_slit_stare_vis)
raw_sci_slit_stare_nir_class = classification_rule('OBJECT_SLIT_STARE_NIR', rules.is_sci_slit_stare_nir)

raw_sci_ifu_stare_uvb_class = classification_rule('OBJECT_IFU_STARE_UVB', rules.is_sci_ifu_stare_uvb)
raw_sci_ifu_stare_vis_class = classification_rule('OBJECT_IFU_STARE_VIS', rules.is_sci_ifu_stare_vis)
raw_sci_ifu_stare_nir_class = classification_rule('OBJECT_IFU_STARE_NIR', rules.is_sci_ifu_stare_nir)

raw_sci_slit_off_uvb_class = classification_rule('OBJECT_SLIT_OFFSET_UVB', rules.is_sci_slit_off_uvb)
raw_sci_slit_off_vis_class = classification_rule('OBJECT_SLIT_OFFSET_VIS', rules.is_sci_slit_off_vis)
raw_sci_slit_off_nir_class = classification_rule('OBJECT_SLIT_OFFSET_NIR', rules.is_sci_slit_off_nir)

raw_sky_slit_off_uvb_class = classification_rule('SKY_SLIT_UVB', rules.is_sky_slit_off_uvb)
raw_sky_slit_off_vis_class = classification_rule('SKY_SLIT_VIS', rules.is_sky_slit_off_vis)
raw_sky_slit_off_nir_class = classification_rule('SKY_SLIT_NIR', rules.is_sky_slit_off_nir)

raw_sci_ifu_offset_uvb_class = classification_rule('OBJECT_IFU_OFFSET_UVB', rules.is_sci_ifu_off_uvb)
raw_sci_ifu_offset_vis_class = classification_rule('OBJECT_IFU_OFFSET_VIS', rules.is_sci_ifu_off_vis)
raw_sci_ifu_offset_nir_class = classification_rule('OBJECT_IFU_OFFSET_NIR', rules.is_sci_ifu_off_nir)

raw_sky_ifu_offset_uvb_class = classification_rule('SKY_IFU_UVB', rules.is_sky_ifu_off_uvb)
raw_sky_ifu_offset_vis_class = classification_rule('SKY_IFU_VIS', rules.is_sky_ifu_off_vis)
raw_sky_ifu_offset_nir_class = classification_rule('SKY_IFU_NIR', rules.is_sky_ifu_off_nir)
raw_sky_ifu_mapping_uvb_class = classification_rule('SKY_IFU_MAP_UVB', rules.is_sky_ifu_map_uvb)
raw_sky_ifu_mapping_vis_class = classification_rule('SKY_IFU_MAP_VIS', rules.is_sky_ifu_map_vis)
raw_sky_ifu_mapping_nir_class = classification_rule('SKY_IFU_MAP_NIR', rules.is_sky_ifu_map_nir)

raw_sci_slit_nod_uvb_class = classification_rule('OBJECT_SLIT_NOD_UVB', rules.is_sci_slit_nod_uvb)
raw_sci_slit_nod_vis_class = classification_rule('OBJECT_SLIT_NOD_VIS', rules.is_sci_slit_nod_vis)
raw_sci_slit_nod_nir_class = classification_rule('OBJECT_SLIT_NOD_NIR', rules.is_sci_slit_nod_nir)

raw_sci_ifu_nod_uvb_class = classification_rule('SCI_IFU_NOD_UVB', rules.is_sci_ifu_nod_uvb)
raw_sci_ifu_nod_vis_class = classification_rule('SCI_IFU_NOD_VIS', rules.is_sci_ifu_nod_vis)
raw_sci_ifu_nod_nir_class = classification_rule('SCI_IFU_NOD_NIR', rules.is_sci_ifu_nod_nir)

raw_tell_ifu_nod_uvb_class = classification_rule('SCI_IFU_NOD_UVB', rules.is_tell_ifu_nod_uvb)
raw_tell_ifu_nod_vis_class = classification_rule('SCI_IFU_NOD_VIS', rules.is_tell_ifu_nod_vis)
raw_tell_ifu_nod_nir_class = classification_rule('SCI_IFU_NOD_NIR', rules.is_tell_ifu_nod_nir)
raw_tell_ifu_stare_uvb_class = classification_rule('SCI_IFU_STARE_UVB', rules.is_tell_ifu_stare_uvb)
raw_tell_ifu_stare_vis_class = classification_rule('SCI_IFU_STARE_VIS', rules.is_tell_ifu_stare_vis)
raw_tell_ifu_stare_nir_class = classification_rule('SCI_IFU_STARE_NIR', rules.is_tell_ifu_stare_nir)
raw_tell_ifu_offset_uvb_class = classification_rule('SCI_IFU_OFFSET_UVB', rules.is_tell_ifu_offset_uvb)
raw_tell_ifu_offset_vis_class = classification_rule('SCI_IFU_OFFSET_VIS', rules.is_tell_ifu_offset_vis)
raw_tell_ifu_offset_nir_class = classification_rule('SCI_IFU_OFFSET_NIR', rules.is_tell_ifu_offset_nir)

acquisition_class = classification_rule("ACQUISITION", rules.is_acquisition)
SCI_SLIT_FLUX_IDP_UVB = classification_rule("SPECTRUM_1D", {"pro.catg": "SCI_SLIT_FLUX_IDP_UVB"})
SCI_SLIT_FLUX_IDP_VIS = classification_rule("SPECTRUM_1D", {"pro.catg": "SCI_SLIT_FLUX_IDP_VIS"})
SCI_SLIT_FLUX_IDP_NIR = classification_rule("SPECTRUM_1D", {"pro.catg": "SCI_SLIT_FLUX_IDP_NIR"})
SCI_SLIT_IDP_UVB = classification_rule("SPECTRUM_1D", {"pro.catg": "SCI_SLIT_IDP_UVB"})
SCI_SLIT_IDP_VIS = classification_rule("SPECTRUM_1D", {"pro.catg": "SCI_SLIT_IDP_VIS"})
SCI_SLIT_IDP_NIR = classification_rule("SPECTRUM_1D", {"pro.catg": "SCI_SLIT_IDP_NIR"})

# ---------------- STATIC DATA PRODUCTS --------------------------------
bp_map_rp_uvb_class = classification_rule('BP_MAP_RP_UVB')
bp_map_rp_vis_class = classification_rule('BP_MAP_RP_VIS')
bp_map_rp_nir_class = classification_rule('BP_MAP_RP_NIR')
bp_map_rp_agc_class = classification_rule('BP_MAP_RP_AGC')

xsh_mod_cfg_tab_uvb_class = classification_rule('XSH_MOD_CFG_TAB_UVB')
xsh_mod_cfg_tab_vis_class = classification_rule('XSH_MOD_CFG_TAB_VIS')
xsh_mod_cfg_tab_nir_class = classification_rule('XSH_MOD_CFG_TAB_NIR')
xsh_mod_cfg_opt_2d_uvb_class = classification_rule('XSH_MOD_CFG_OPT_2D_UVB')
xsh_mod_cfg_opt_2d_vis_class = classification_rule('XSH_MOD_CFG_OPT_2D_VIS')
xsh_mod_cfg_opt_2d_nir_class = classification_rule('XSH_MOD_CFG_OPT_2D_NIR')
theo_tab_uvb_class = classification_rule('THEO_TAB_SING_UVB')
theo_tab_vis_class = classification_rule('THEO_TAB_SING_VIS')
theo_tab_nir_class = classification_rule('THEO_TAB_SING_NIR')

flux_std_catalog_uvb_class = classification_rule('FLUX_STD_CATALOG_UVB')
flux_std_catalog_vis_class = classification_rule('FLUX_STD_CATALOG_VIS')
flux_std_catalog_nir_class = classification_rule('FLUX_STD_CATALOG_NIR')

arc_line_list_afc_uvb_class = classification_rule('ARC_LINE_LIST_AFC_UVB')
arc_line_list_afc_vis_class = classification_rule('ARC_LINE_LIST_AFC_VIS')
arc_line_list_afc_nir_class = classification_rule('ARC_LINE_LIST_AFC_NIR')

atmos_ext_uvb_class = classification_rule('ATMOS_EXT_UVB')
atmos_ext_vis_class = classification_rule('ATMOS_EXT_VIS')
atmos_ext_nir_class = classification_rule('ATMOS_EXT_NIR')

tell_mod_cat_uvb_class = classification_rule('TELL_MOD_CAT_UVB')
tell_mod_cat_vis_class = classification_rule('TELL_MOD_CAT_VIS')
tell_mod_cat_nir_class = classification_rule('TELL_MOD_CAT_NIR')
tell_mask_uvb_class = classification_rule('TELL_MASK_UVB')
tell_mask_vis_class = classification_rule('TELL_MASK_VIS')
tell_mask_nir_class = classification_rule('TELL_MASK_NIR')

sky_line_list_uvb_class = classification_rule('SKY_LINE_LIST_UVB')
sky_line_list_vis_class = classification_rule('SKY_LINE_LIST_VIS')
sky_line_list_nir_class = classification_rule('SKY_LINE_LIST_NIR')

sky_slit_uvb_class = classification_rule('SKY_SLIT_UVB')
sky_slit_vis_class = classification_rule('SKY_SLIT_VIS')
sky_slit_nir_class = classification_rule('SKY_SLIT_NIR')

arc_line_list_uvb_class = classification_rule('ARC_LINE_LIST_UVB')
arc_line_list_vis_class = classification_rule('ARC_LINE_LIST_VIS')
arc_line_list_nir_class = classification_rule('ARC_LINE_LIST_NIR')

resp_fit_points_cat_uvb_class = classification_rule('RESP_FIT_POINTS_CAT_UVB')
resp_fit_points_cat_vis_class = classification_rule('RESP_FIT_POINTS_CAT_VIS')
resp_fit_points_cat_nir_class = classification_rule('RESP_FIT_POINTS_CAT_NIR')

spectral_format_tab_uvb_class = classification_rule('SPECTRAL_FORMAT_TAB_UVB')
spectral_format_tab_vis_class = classification_rule('SPECTRAL_FORMAT_TAB_VIS')
spectral_format_tab_nir_class = classification_rule('SPECTRAL_FORMAT_TAB_NIR')
spectral_format_tab_nir_jh_class = classification_rule('SPECTRAL_FORMAT_TAB_JH_NIR')

mresponse_merge1d_slit_uvb_class = classification_rule('RESPONSE_MERGE1D_SLIT_UVB')
mresponse_merge1d_slit_vis_class = classification_rule('RESPONSE_MERGE1D_SLIT_VIS')
mresponse_merge1d_slit_nir_class = classification_rule('RESPONSE_MERGE1D_SLIT_NIR')
reference_response_uvb_class = classification_rule("RRESPONSE_MERGE1D_SLIT_UVB",
                                                   {"instrume": "XSHOOTER", "pro.catg": "RRESPONSE_MERGE1D_SLIT_UVB"})
reference_response_vis_class = classification_rule("RRESPONSE_MERGE1D_SLIT_VIS",
                                                   {"instrume": "XSHOOTER", "pro.catg": "RRESPONSE_MERGE1D_SLIT_VIS"})
reference_response_nir_class = classification_rule("RRESPONSE_MERGE1D_SLIT_NIR",
                                                   {"instrume": "XSHOOTER", "pro.catg": "RRESPONSE_MERGE1D_SLIT_NIR"})

sky_map_nir_class = classification_rule('SKY_MAP_NIR')

ifu_cfg_tab_uvb_class = classification_rule('IFU_CFG_TAB_UVB')
ifu_cfg_tab_vis_class = classification_rule('IFU_CFG_TAB_VIS')
ifu_cfg_tab_nir_class = classification_rule('IFU_CFG_TAB_NIR')

arc_line_list_intmon_uvb_class = classification_rule('ARC_LINE_LIST_INTMON_UVB')
arc_line_list_intmon_vis_class = classification_rule('ARC_LINE_LIST_INTMON_VIS')
arc_line_list_intmon_nir_class = classification_rule('ARC_LINE_LIST_INTMON_NIR')

sky_sub_bkpts_uvb_class = classification_rule('SKY_SUB_BKPTS_UVB')
sky_sub_bkpts_vis_class = classification_rule('SKY_SUB_BKPTS_VIS')
sky_sub_bkpts_nir_class = classification_rule('SKY_SUB_BKPTS_NIR')

# ---------------- PIPELINE DATA PRODUCTS --------------------------------
bp_map_nl_uvb = classification_rule('BP_MAP_NL_UVB')
bp_map_nl_vis = classification_rule('BP_MAP_NL_VIS')
bp_map_nl_nir = classification_rule('BP_MAP_NL_NIR')

master_bias_uvb = classification_rule('MASTER_BIAS_UVB')
master_bias_vis = classification_rule('MASTER_BIAS_VIS')
master_bias_agc = classification_rule('MASTER_BIAS_AGC')

master_dark_uvb = classification_rule('MASTER_DARK_UVB')
master_dark_vis = classification_rule('MASTER_DARK_VIS')
master_dark_nir = classification_rule('MASTER_DARK_NIR')

order_tab_guess_uvb = classification_rule('ORDER_TAB_GUESS_UVB')
order_tab_guess_vis = classification_rule('ORDER_TAB_GUESS_VIS')
order_tab_guess_nir = classification_rule('ORDER_TAB_GUESS_NIR')

xsh_mod_cfg_opt_fmt_uvb = classification_rule('XSH_MOD_CFG_OPT_FMT_UVB')
xsh_mod_cfg_opt_fmt_vis = classification_rule('XSH_MOD_CFG_OPT_FMT_VIS')
xsh_mod_cfg_opt_fmt_nir = classification_rule('XSH_MOD_CFG_OPT_FMT_NIR')
wave_tab_2d_uvb_class = classification_rule('WAVE_TAB_2D_UVB')
wave_tab_2d_vis_class = classification_rule('WAVE_TAB_2D_VIS')
wave_tab_2d_nir_class = classification_rule('WAVE_TAB_2D_NIR')

WAVE_TAB_ARC_IFU_DOWN_UVB = classification_rule('WAVE_TAB_ARC_IFU_DOWN_UVB')
WAVE_TAB_ARC_IFU_CEN_UVB = classification_rule('WAVE_TAB_ARC_IFU_CEN_UVB')
WAVE_TAB_ARC_IFU_UP_UVB = classification_rule('WAVE_TAB_ARC_IFU_UP_UVB')
WAVE_TAB_ARC_IFU_DOWN_VIS = classification_rule('WAVE_TAB_ARC_IFU_DOWN_VIS')
WAVE_TAB_ARC_IFU_CEN_VIS = classification_rule('WAVE_TAB_ARC_IFU_CEN_VIS')
WAVE_TAB_ARC_IFU_UP_VIS = classification_rule('WAVE_TAB_ARC_IFU_UP_VIS')
WAVE_TAB_ARC_IFU_DOWN_NIR = classification_rule('WAVE_TAB_ARC_IFU_DOWN_NIR')
WAVE_TAB_ARC_IFU_CEN_NIR = classification_rule('WAVE_TAB_ARC_IFU_CEN_NIR')
WAVE_TAB_ARC_IFU_UP_NIR = classification_rule('WAVE_TAB_ARC_IFU_UP_NIR')

WAVE_TAB_AFC_UVB = classification_rule('WAVE_TAB_AFC_UVB')
WAVE_TAB_AFC_VIS = classification_rule('WAVE_TAB_AFC_VIS')
WAVE_TAB_AFC_NIR = classification_rule('WAVE_TAB_AFC_NIR')

WAVE_MAP_UVB = classification_rule('WAVE_MAP_UVB')
WAVE_MAP_VIS = classification_rule('WAVE_MAP_VIS')
WAVE_MAP_NIR = classification_rule('WAVE_MAP_NIR')

order_tab_centr_uvb = classification_rule('ORDER_TAB_CENTR_UVB')
order_tab_centr_vis = classification_rule('ORDER_TAB_CENTR_VIS')
order_tab_centr_nir = classification_rule('ORDER_TAB_CENTR_NIR')

order_tab_edges_slit_uvb = classification_rule('ORDER_TAB_EDGES_SLIT_UVB')
order_tab_edges_slit_vis = classification_rule('ORDER_TAB_EDGES_SLIT_VIS')
order_tab_edges_slit_nir = classification_rule('ORDER_TAB_EDGES_SLIT_NIR')
order_tab_edges_ifu_uvb = classification_rule('ORDER_TAB_EDGES_IFU_UVB')
order_tab_edges_ifu_vis = classification_rule('ORDER_TAB_EDGES_IFU_VIS')
order_tab_edges_ifu_nir = classification_rule('ORDER_TAB_EDGES_IFU_NIR')

master_flat_slit_uvb = classification_rule('MASTER_FLAT_SLIT_UVB')
master_flat_slit_vis = classification_rule('MASTER_FLAT_SLIT_VIS')
master_flat_slit_nir = classification_rule('MASTER_FLAT_SLIT_NIR')
master_flat_ifu_uvb = classification_rule('MASTER_FLAT_IFU_UVB')
master_flat_ifu_vis = classification_rule('MASTER_FLAT_IFU_VIS')
master_flat_ifu_nir = classification_rule('MASTER_FLAT_IFU_NIR')

xsh_mod_cfg_opt_2d_uvb = classification_rule('XSH_MOD_CFG_OPT_2D_UVB')
xsh_mod_cfg_opt_2d_vis = classification_rule('XSH_MOD_CFG_OPT_2D_VIS')
xsh_mod_cfg_opt_2d_nir = classification_rule('XSH_MOD_CFG_OPT_2D_NIR')

DISP_TAB_UVB = classification_rule('DISP_TAB_UVB')
DISP_TAB_VIS = classification_rule('DISP_TAB_VIS')
DISP_TAB_NIR = classification_rule('DISP_TAB_NIR')

order_tab_afc_slit_uvb = classification_rule('ORDER_TAB_AFC_SLIT_UVB')
order_tab_afc_slit_vis = classification_rule('ORDER_TAB_AFC_SLIT_VIS')
order_tab_afc_slit_nir = classification_rule('ORDER_TAB_AFC_SLIT_NIR')
order_tab_afc_ifu_uvb = classification_rule('ORDER_TAB_AFC_IFU_UVB')
order_tab_afc_ifu_vis = classification_rule('ORDER_TAB_AFC_IFU_VIS')
order_tab_afc_ifu_nir = classification_rule('ORDER_TAB_AFC_IFU_NIR')

xsh_mod_cfg_opt_afc_uvb = classification_rule('XSH_MOD_CFG_OPT_AFC_UVB')
xsh_mod_cfg_opt_afc_vis = classification_rule('XSH_MOD_CFG_OPT_AFC_VIS')
xsh_mod_cfg_opt_afc_nir = classification_rule('XSH_MOD_CFG_OPT_AFC_NIR')

disp_tab_afc_uvb = classification_rule('DISP_TAB_AFC_UVB')
disp_tab_afc_vis = classification_rule('DISP_TAB_AFC_VIS')
disp_tab_afc_nir = classification_rule('DISP_TAB_AFC_NIR')

response_merge1d_slit_uvb = classification_rule('RESPONSE_MERGE1D_SLIT_UVB')
response_merge1d_slit_vis = classification_rule('RESPONSE_MERGE1D_SLIT_VIS')
response_merge1d_slit_nir = classification_rule('RESPONSE_MERGE1D_SLIT_NIR')

# molecfit classifications
SCI_IDP_NIR = classification_rule("SCI_SLIT_FLUX_IDP_NIR")
SCI_IDP_VIS = classification_rule("SCI_SLIT_FLUX_IDP_VIS")
SCI_IDP_UVB = classification_rule("SCI_SLIT_FLUX_IDP_UVB")
TELL_IDP_NIR = classification_rule("TELL_SLIT_FLUX_IDP_NIR")
TELL_IDP_VIS = classification_rule("TELL_SLIT_FLUX_IDP_VIS")
TELL_IDP_UVB = classification_rule("TELL_SLIT_FLUX_IDP_UVB")
STD_IDP_NIR = classification_rule("STD_SLIT_FLUX_IDP_NIR")
STD_IDP_VIS = classification_rule("STD_SLIT_FLUX_IDP_VIS")
STD_IDP_UVB = classification_rule("STD_SLIT_FLUX_IDP_UVB")
BEST_FIT_PARAMETERS_STD_VIS = classification_rule("BEST_FIT_PARAMETERS_STD_VIS")
BEST_FIT_PARAMETERS_STD_NIR = classification_rule("BEST_FIT_PARAMETERS_STD_NIR")
BEST_FIT_MODEL_STD_VIS = classification_rule("BEST_FIT_MODEL_STD_VIS")
BEST_FIT_MODEL_STD_NIR = classification_rule("BEST_FIT_MODEL_STD_NIR")
BEST_FIT_PARAMETERS_SCI_VIS = classification_rule("BEST_FIT_PARAMETERS_SCI_VIS")
BEST_FIT_PARAMETERS_SCI_NIR = classification_rule("BEST_FIT_PARAMETERS_SCI_NIR")
BEST_FIT_MODEL_SCI_VIS = classification_rule("BEST_FIT_MODEL_SCI_VIS")
BEST_FIT_MODEL_SCI_NIR = classification_rule("BEST_FIT_MODEL_SCI_NIR")
GDAS_VIS = classification_rule("GDAS_VIS ")
GDAS_NIR = classification_rule("GDAS_NIR")
ATM_PARAMETERS_STD_VIS = classification_rule("ATM_PARAMETERS_STD_VIS")
ATM_PARAMETERS_STD_NIR = classification_rule("ATM_PARAMETERS_STD_NIR")
ATM_PARAMETERS_SCI_VIS = classification_rule("ATM_PARAMETERS_SCI_VIS")
ATM_PARAMETERS_SCI_NIR = classification_rule("ATM_PARAMETERS_SCI_NIR")
MOLECULES_NIR = classification_rule("MODEL_MOLECULES_NIR", {kwd.pro_catg: "MODEL_MOLECULES_NIR", kwd.seq_arm: "NIR"})
MOLECULES_VIS = classification_rule("MODEL_MOLECULES_VIS", {kwd.pro_catg: "MODEL_MOLECULES_VIS", kwd.seq_arm: "VIS"})
WAVE_INCLUDE_NIR = classification_rule("WAVE_INCLUDE_NIR",
                                       {kwd.pro_catg: ["WAVE_INCLUDE", "WAVE_INCLUDE_NIR"], kwd.seq_arm: "NIR"})
WAVE_INCLUDE_VIS = classification_rule("WAVE_INCLUDE_VIS",
                                       {kwd.pro_catg: ["WAVE_INCLUDE", "WAVE_INCLUDE_VIS"], kwd.seq_arm: "VIS"})
TELLURIC_CORR_VIS = classification_rule("TELLURIC_CORR_VIS")
TELLURIC_CORR_NIR = classification_rule("TELLURIC_CORR_NIR")
SPECTRUM_1D = classification_rule("SPECTRUM_1D")
