from edps import subworkflow, task, QC1_CALIB, CALCHECKER, ReportInput

from .xshooter_association_rules import associate_bias_cals
from .xshooter_datasources import *
from .xshooter_task_functions import *


@subworkflow('fit_orders', "")
def fit_orders(alternatives_spectral_format, bias, bp_map_rp_nir):
    # This subworkflow executes the two tasks that deal with the definition of the echelle orders.
    #

    # Task to predict the tracing of the orders.
    # If a master calibration is used as associated input, it needs to match the arm
    # of the main input. This is the reason why there are conditions for associated and alternative input.
    # If the input from an upstream task instead, the proper match is taken care of by the match rule.
    predict = (task('order_prediction')
               .with_recipe('xsh_predict')
               .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
               .with_report("xshooter_formatcheck", ReportInput.RECIPE_INPUTS_OUTPUTS)
               .with_main_input(raw_fmtchk)
               .with_dynamic_parameter('arm', which_arm)
               .with_dynamic_parameter('jh', which_jh)
               .with_associated_input(raw_fmtchk_nir_off, condition=is_NIR, min_ret=1, max_ret=1)
               .with_alternative_associated_inputs(alternatives_spectral_format)
               .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                      match_rules=associate_bias_cals)
               .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                      match_rules=associate_bias_cals)
               .with_associated_input(arc_line_list)
               .with_associated_input(arc_line_list_intmon)
               .with_associated_input(xsh_mod_cfg_tab, condition=physical_mode)
               .with_associated_input(theo_tab_sing, condition=polynomial_mode)
               .with_associated_input(bp_map_rp_nir, min_ret=1, condition=is_NIR)
               .with_job_processing(set_predict_processing)
               .with_input_filter(bp_map_nl_uvb, bp_map_nl_vis, bp_map_nl_nir, fmtchk_nir_off_class,
                                  master_bias_uvb, master_bias_vis,
                                  arc_line_list_uvb_class, arc_line_list_vis_class, arc_line_list_nir_class,
                                  xsh_mod_cfg_tab_uvb_class, xsh_mod_cfg_tab_vis_class, xsh_mod_cfg_tab_nir_class,
                                  theo_tab_uvb_class, theo_tab_vis_class, theo_tab_nir_class)
               .with_meta_targets([QC1_CALIB, CALCHECKER])
               .build())

    # Task to define the coordinates of each order, starting from the predictions computed above
    # If a master calibration is used as associated input, it needs to match the arm
    # of the main input. This is the reason why there are conditions for associated and alternative input.
    # If the input from an upstream task instead, the proper match is taken care of by the match rule.
    orderdef = (task('order_definition')
                .with_recipe('xsh_orderpos')
                .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                .with_report("xshooter_orderdef_flatfield", ReportInput.RECIPE_INPUTS_OUTPUTS)
                .with_main_input(raw_orderdef)
                .with_dynamic_parameter('arm', which_arm)
                .with_dynamic_parameter('jh', which_jh)
                .with_associated_input(raw_orderdef_nir_off, condition=is_NIR, max_ret=1000)
                .with_associated_input(raw_orderdef_qth_uvb, condition=is_UVB, min_ret=0)
                .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                       match_rules=associate_bias_cals)
                .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                       match_rules=associate_bias_cals)
                .with_associated_input(bp_map_rp_nir, min_ret=1, condition=is_NIR)
                .with_alternative_associated_inputs(alternatives_spectral_format)
                .with_associated_input(predict, [order_tab_guess_uvb], condition=is_UVB, min_ret=1)
                .with_associated_input(predict, [order_tab_guess_vis], condition=is_VIS, min_ret=1)
                .with_associated_input(predict, [order_tab_guess_nir], condition=is_NIR, min_ret=1)
                .with_job_processing(set_orderpos_processing)
                .with_input_filter(spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                   spectral_format_tab_nir_class, spectral_format_tab_nir_jh_class,
                                   order_tab_guess_uvb, order_tab_guess_vis, order_tab_guess_nir,
                                   master_bias_vis, master_bias_uvb, master_dark_uvb, master_dark_vis,
                                   bp_map_nl_uvb, bp_map_nl_vis, bp_map_nl_nir, orderdef_uvb_qth_class,
                                   bp_map_rp_uvb_class, bp_map_rp_vis_class, bp_map_rp_nir_class)
                .with_meta_targets([QC1_CALIB, CALCHECKER])
                .build())

    orderdefinition_calibrations = (alternative_associated_inputs()
                                    .with_associated_input(orderdef, [order_tab_centr_uvb], condition=is_UVB)
                                    .with_associated_input(orderdef, [order_tab_centr_vis], condition=is_VIS)
                                    .with_associated_input(orderdef, [order_tab_centr_nir], condition=is_NIR))

    return predict, orderdef, orderdefinition_calibrations
