from edps import subworkflow, task, QC1_CALIB, CALCHECKER, ReportInput

from .xshooter_association_rules import associate_bias_cals, associate_bias_cals_agc, associate_dark_optical, \
    associate_flat_to_dmap_nir, associate_flat_uvb, associate_flat_vis, associate_flat_nir, associate_flat_uvb_arcs, \
    associate_flat_vis_arcs, associate_flat_nir_arcs, associate_flat_flex_opt, associate_flat_flex_nir, \
    associate_flat_to_dmap_opt
from .xshooter_datasources import *
from .xshooter_task_functions import *


def run_lam_flat(input_flat, input_flat_off, task_name, bias, alternatives_spectral_format,
                 orderdefinition_calibrations, dark, bp_map_rp_nir, qth):
    lamp_flat = (task(task_name)
                 .with_recipe('xsh_mflat')
                 .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                 .with_report('xshooter_echelle_flatfield', ReportInput.RECIPE_INPUTS_OUTPUTS)
                 .with_main_input(input_flat)
                 .with_dynamic_parameter("arm", which_arm)
                 .with_dynamic_parameter("jh", which_jh)
                 .with_dynamic_parameter("ifu", which_ifu)
                 .with_associated_input(input_flat_off, max_ret=1000, condition=is_NIR)
                 .with_alternative_associated_inputs(alternatives_spectral_format)
                 .with_alternative_associated_inputs(orderdefinition_calibrations)
                 .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                        match_rules=associate_bias_cals)
                 .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                        match_rules=associate_bias_cals)
                 .with_associated_input(dark, [master_dark_uvb], condition=use_dark_UVB, min_ret=0,
                                        match_rules=associate_dark_optical)
                 .with_associated_input(dark, [master_dark_vis], condition=use_dark_VIS, min_ret=0,
                                        match_rules=associate_dark_optical)
                 .with_associated_input(bp_map_rp_nir, condition=is_NIR)
                 .with_job_processing(set_flat_parameters)
                 .with_input_filter(spectral_format_tab_uvb_class, order_tab_centr_uvb, master_bias_uvb,
                                    master_dark_uvb, bp_map_nl_uvb, spectral_format_tab_vis_class, order_tab_centr_vis,
                                    master_bias_vis, flat_slit_nir_off_class,
                                    master_dark_vis, bp_map_nl_vis, spectral_format_tab_nir_class, order_tab_centr_nir,
                                    spectral_format_tab_nir_jh_class, master_dark_nir, bp_map_nl_nir,
                                    bp_map_rp_nir_class)
                 .with_meta_targets([QC1_CALIB, CALCHECKER]))

    # For HC tasks, I need also qth flat for arm UVB (datasource raw_flat_qth_hc).
    if task_name == "lamp_flat_hc" and qth is not None:
        lamp_flat = (lamp_flat
                     .with_associated_input(qth, condition=is_UVB))

    return lamp_flat.build()


@subworkflow('flat', "")
def process_flats(raw_skyflat_agc, raw_flat, raw_flat_nir_off, raw_flat_hc, raw_flat_qth_hc, raw_flat_nir_off_hc, bias,
                  alternatives_spectral_format,
                  orderdefinition_calibrations, dark, bp_map_rp_nir):
    # The subworkflow processes all the raw flats: both those obtained with the acquisition camera (used only for
    # instrument monitoring) and those obtained with the lamps, which are then used by other tasks.
    # The lamp flats are grouped according to the files that need them, and returned to the main workflow.

    # The camera flats are not used in the reduction flow, therefore there is no recipe attached. But
    # they are used to create a quality control report which is specified here.
    # Biases are associated so that they are delivered by CalSelector.
    acquisition_camera_flat = (task("acquisition_camera_flat")
                               .with_main_input(raw_skyflat_agc)
                               .with_associated_input(bias, [master_bias_agc], condition=is_AGC, min_ret=1,
                                                      match_rules=associate_bias_cals_agc)
                               .with_meta_targets([QC1_CALIB, CALCHECKER])
                               .build())

    # Task for reducing lamp flats, running a single recipe for all the arms (UVB, VIS, NIR, AGC) and
    # modes (SLIT, IFU). If a master calibration is used as associated input, it needs to match the arm
    # of the main input. This is the reason why there are conditions for associated and alternative inputs.
    # If the input from an upstream task instead, the proper match is taken care of by the match rule.
    lamp_flat = run_lam_flat(raw_flat, raw_flat_nir_off, "lamp_flat", bias, alternatives_spectral_format,
                             orderdefinition_calibrations, dark, bp_map_rp_nir, None)

    # This task reduces lamp_flat_hc, that are regular IFU flats but with nexp =1. They are not used further in the
    # reduction
    lamp_flat_hc = run_lam_flat(raw_flat_hc, raw_flat_nir_off_hc, "lamp_flat_hc", bias, alternatives_spectral_format,
                                orderdefinition_calibrations, dark, bp_map_rp_nir, raw_flat_qth_hc)

    # flat calibrations used for science and response tasks
    flat_calibrations = (alternative_associated_inputs()
                         .with_associated_input(lamp_flat, [master_flat_slit_uvb, order_tab_edges_slit_uvb],
                                                condition=is_UVB_slit, match_rules=associate_flat_uvb)
                         .with_associated_input(lamp_flat, [master_flat_slit_vis, order_tab_edges_slit_vis],
                                                condition=is_VIS_slit, match_rules=associate_flat_vis)
                         .with_associated_input(lamp_flat, [master_flat_slit_nir, order_tab_edges_slit_nir],
                                                condition=is_NIR_slit, match_rules=associate_flat_nir)
                         .with_associated_input(lamp_flat, [master_flat_ifu_uvb, order_tab_edges_ifu_uvb],
                                                condition=is_UVB_ifu, match_rules=associate_flat_uvb)
                         .with_associated_input(lamp_flat, [master_flat_ifu_vis, order_tab_edges_ifu_vis],
                                                condition=is_VIS_ifu, match_rules=associate_flat_vis)
                         .with_associated_input(lamp_flat, [master_flat_ifu_nir, order_tab_edges_ifu_nir],
                                                condition=is_NIR_ifu, match_rules=associate_flat_nir))

    # flat calibrations used for arc task
    flat_calibrations_for_arcs = (alternative_associated_inputs()
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_uvb],
                                                         condition=is_UVB_slit, match_rules=associate_flat_uvb_arcs)
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_vis],
                                                         condition=is_VIS_slit, match_rules=associate_flat_vis_arcs)
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_nir],
                                                         condition=is_NIR_slit, match_rules=associate_flat_nir_arcs)
                                  .with_associated_input(lamp_flat, [order_tab_edges_ifu_uvb],
                                                         condition=is_UVB_ifu, match_rules=associate_flat_uvb_arcs)
                                  .with_associated_input(lamp_flat, [order_tab_edges_ifu_vis],
                                                         condition=is_VIS_ifu, match_rules=associate_flat_vis_arcs)
                                  .with_associated_input(lamp_flat, [order_tab_edges_ifu_nir],
                                                         condition=is_NIR_ifu, match_rules=associate_flat_nir_arcs))

    # flat calibrations used for flexures correction task
    flat_calibrations_for_flex = (alternative_associated_inputs()
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_uvb], min_ret=1,
                                                         condition=is_UVB_slit, match_rules=associate_flat_flex_opt)
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_vis, ], min_ret=1,
                                                         condition=is_VIS_slit, match_rules=associate_flat_flex_opt)
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_nir], min_ret=1,
                                                         condition=is_NIR_slit, match_rules=associate_flat_flex_nir)
                                  .with_associated_input(lamp_flat, [order_tab_edges_ifu_uvb], condition=is_UVB_ifu,
                                                         match_rules=associate_flat_flex_opt, min_ret=1)
                                  .with_associated_input(lamp_flat, [order_tab_edges_ifu_vis], condition=is_VIS_ifu,
                                                         match_rules=associate_flat_flex_opt, min_ret=1)
                                  .with_associated_input(lamp_flat, [order_tab_edges_ifu_nir], condition=is_NIR_ifu,
                                                         match_rules=associate_flat_flex_nir, min_ret=1))

    # flat calibrations used for wavelength_calibration_2d task
    flat_calibrations_for_dmap = (alternative_associated_inputs()
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_uvb], min_ret=1,
                                                         condition=is_UVB_slit, match_rules=associate_flat_to_dmap_opt)
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_vis], min_ret=1,
                                                         condition=is_VIS_slit, match_rules=associate_flat_to_dmap_opt)
                                  .with_associated_input(lamp_flat, [order_tab_edges_slit_nir], min_ret=1,
                                                         condition=is_NIR_slit, match_rules=associate_flat_to_dmap_nir))

    return acquisition_camera_flat, lamp_flat, lamp_flat_hc, flat_calibrations, flat_calibrations_for_arcs, flat_calibrations_for_flex, flat_calibrations_for_dmap
