from edps import QC1_CALIB, subworkflow, task, ReportInput

from .xshooter_datasources import *
from .xshooter_task_functions import *


@subworkflow("linearity", "")
def xshoo_linearity():
    # This subworkflow executes the two tasks aimed at monitoring the linearity of the detector. Their products are not
    # used further the reduction chain.

    # UVB and VIS observations
    detmon_opt = (task('detmon_optical')
                  .with_recipe('detmon_opt_lg')
                  .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                  .with_report('xshooter_detmon', ReportInput.RECIPE_INPUTS_OUTPUTS)
                  .with_main_input(raw_linearity_detmon_uvbvis_on)
                  .with_dynamic_parameter('arm', which_arm)
                  .with_associated_input(raw_linearity_detmon_uvbvis_off, min_ret=1, max_ret=20)
                  .with_job_processing(detmon_setting)
                  .with_meta_targets([QC1_CALIB])
                  .build())
    # NIR observations
    detmon_nir = (task('detmon_nir')
                  .with_recipe('detmon_ir_lg')
                  .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                  .with_report('xshooter_detmon', ReportInput.RECIPE_INPUTS_OUTPUTS)
                  .with_main_input(raw_linearity_detmon_nir_on)
                  .with_associated_input(raw_linearity_detmon_nir_off, min_ret=8, max_ret=20)
                  .with_job_processing(detmon_setting)
                  .with_meta_targets([QC1_CALIB])
                  .build())

    return detmon_opt, detmon_nir
