from edps import QC1_CALIB, subworkflow, task, ReportInput

from .xshooter_association_rules import associate_bias_cals
from .xshooter_datasources import *
from .xshooter_task_functions import *

# define local metatarget
response = "response"


@subworkflow('response', "")
def xshoo_response(bias, alternatives_flat, alternatives_dmap, alternatives_flex, alternatives_flex_nod,
                   alternatives_spectral_format, alternatives_bp_map_rp):
    # This subworkflow reduces the flux standards to produce the response curve correction.

    alternatives_catalogs = (alternative_associated_inputs()
                             .with_associated_input(flux_std_catalog_uvb, condition=is_UVB)
                             .with_associated_input(flux_std_catalog_vis, condition=is_VIS)
                             .with_associated_input(flux_std_catalog_nir, condition=is_NIR))

    # Response curve for offset exposures
    response_slit_offset = (task('response_offset')
                            .with_main_input(raw_standard_slit_offset)
                            .with_recipe('xsh_respon_slit_offset')
                            .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                            .with_report('xshooter_specphot_std', ReportInput.RECIPE_INPUTS_OUTPUTS)
                            .with_dynamic_parameter('arm', which_arm)
                            .with_dynamic_parameter('jh', which_jh)
                            .with_dynamic_parameter('ifu', which_ifu)
                            .with_associated_input(raw_flux_sky_slit_off_uvb, condition=is_UVB)
                            .with_associated_input(raw_flux_sky_slit_off_vis, condition=is_VIS)
                            .with_associated_input(raw_flux_sky_slit_off_nir, condition=is_NIR)
                            .with_alternative_associated_inputs(alternatives_flat)
                            .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                   match_rules=associate_bias_cals)
                            .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                   match_rules=associate_bias_cals)
                            .with_alternative_associated_inputs(alternatives_dmap)
                            .with_alternative_associated_inputs(alternatives_flex)
                            .with_alternative_associated_inputs(alternatives_spectral_format)
                            .with_alternative_associated_inputs(alternatives_bp_map_rp)
                            .with_associated_input(atmos_ext)
                            .with_alternative_associated_inputs(alternatives_catalogs)
                            .with_associated_input(resp_fit_points_cat)
                            .with_associated_input(tell_mod_cat, min_ret=0)
                            .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                            .with_associated_input(reference_response, min_ret=0)
                            .with_job_processing(fix_setup_keywords)
                            .with_input_filter(bp_map_nl_uvb, master_bias_uvb, order_tab_edges_slit_uvb,
                                               master_flat_slit_uvb, xsh_mod_cfg_opt_2d_uvb, DISP_TAB_UVB,
                                               order_tab_afc_slit_uvb, xsh_mod_cfg_opt_afc_uvb, disp_tab_afc_uvb,
                                               bp_map_rp_uvb_class, bp_map_nl_vis, master_bias_vis,
                                               order_tab_edges_slit_vis,
                                               master_flat_slit_vis, xsh_mod_cfg_opt_2d_vis, DISP_TAB_VIS,
                                               order_tab_afc_slit_vis, xsh_mod_cfg_opt_afc_vis, disp_tab_afc_vis,
                                               bp_map_rp_vis_class, bp_map_nl_nir, order_tab_edges_slit_nir,
                                               master_flat_slit_nir,
                                               xsh_mod_cfg_opt_2d_nir, DISP_TAB_NIR,
                                               order_tab_afc_slit_nir, xsh_mod_cfg_opt_afc_nir, disp_tab_afc_nir,
                                               bp_map_rp_nir_class, resp_fit_points_cat_uvb_class,
                                               resp_fit_points_cat_vis_class, resp_fit_points_cat_nir_class,
                                               spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                               spectral_format_tab_nir_class, spectral_format_tab_nir_jh_class,
                                               atmos_ext_uvb_class, atmos_ext_vis_class, atmos_ext_nir_class,
                                               flux_std_catalog_uvb_class, flux_std_catalog_vis_class,
                                               flux_std_catalog_nir_class,
                                               reference_response_uvb_class, reference_response_vis_class,
                                               reference_response_nir_class,
                                               tell_mod_cat_vis_class, tell_mod_cat_nir_class)
                            .with_meta_targets([QC1_CALIB, response])
                            .build())

    # Response curve for stare exposures
    response_slit_stare = (task('response_stare')
                           .with_main_input(raw_standard_slit_stare)
                           .with_recipe('xsh_respon_slit_stare')
                           .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                           .with_report('xshooter_specphot_std', ReportInput.RECIPE_INPUTS_OUTPUTS)
                           .with_dynamic_parameter('arm', which_arm)
                           .with_dynamic_parameter('jh', which_jh)
                           .with_dynamic_parameter('ifu', which_ifu)
                           .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                  match_rules=associate_bias_cals)
                           .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                  match_rules=associate_bias_cals)
                           .with_alternative_associated_inputs(alternatives_flat)
                           .with_alternative_associated_inputs(alternatives_dmap)
                           .with_alternative_associated_inputs(alternatives_flex)
                           .with_alternative_associated_inputs(alternatives_spectral_format)
                           .with_alternative_associated_inputs(alternatives_bp_map_rp)
                           .with_associated_input(atmos_ext)
                           .with_alternative_associated_inputs(alternatives_catalogs)
                           .with_associated_input(resp_fit_points_cat)
                           .with_associated_input(sky_line_list, min_ret=0, condition=physical_mode)
                           .with_associated_input(tell_mod_cat, min_ret=0)
                           .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                           .with_associated_input(reference_response, min_ret=0)
                           .with_job_processing(fix_setup_keywords)
                           .with_input_filter(bp_map_nl_uvb, master_bias_uvb, order_tab_edges_slit_uvb,
                                              master_flat_slit_uvb, xsh_mod_cfg_opt_2d_uvb, DISP_TAB_UVB,
                                              order_tab_afc_slit_uvb, xsh_mod_cfg_opt_afc_uvb, disp_tab_afc_uvb,
                                              bp_map_rp_uvb_class, bp_map_nl_vis, master_bias_vis,
                                              order_tab_edges_slit_vis, WAVE_TAB_AFC_UVB, WAVE_TAB_AFC_VIS,
                                              WAVE_TAB_AFC_NIR,
                                              master_flat_slit_vis, xsh_mod_cfg_opt_2d_vis, DISP_TAB_VIS,
                                              order_tab_afc_slit_vis, xsh_mod_cfg_opt_afc_vis, disp_tab_afc_vis,
                                              bp_map_rp_vis_class, bp_map_nl_nir, order_tab_edges_slit_nir,
                                              master_flat_slit_nir,
                                              xsh_mod_cfg_opt_2d_nir, DISP_TAB_NIR,
                                              order_tab_afc_slit_nir, xsh_mod_cfg_opt_afc_nir, disp_tab_afc_nir,
                                              bp_map_rp_nir_class, sky_line_list_uvb_class, sky_line_list_vis_class,
                                              sky_line_list_nir_class, resp_fit_points_cat_uvb_class,
                                              resp_fit_points_cat_vis_class, resp_fit_points_cat_nir_class,
                                              spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                              spectral_format_tab_nir_class, spectral_format_tab_nir_jh_class,
                                              atmos_ext_uvb_class, atmos_ext_vis_class, atmos_ext_nir_class,
                                              flux_std_catalog_uvb_class, flux_std_catalog_vis_class,
                                              flux_std_catalog_nir_class, reference_response_uvb_class,
                                              reference_response_vis_class,
                                              reference_response_nir_class,
                                              tell_mod_cat_vis_class, tell_mod_cat_nir_class)
                           .with_meta_targets([QC1_CALIB, response])
                           .build())

    # Response curve for nodding exposures
    response_slit_nod = (task('response_nod')
                         .with_main_input(raw_standard_slit_nod)
                         .with_recipe('xsh_respon_slit_nod')
                         .with_report('xshooter_rawdisp', ReportInput.RECIPE_INPUTS)
                         .with_report('xshooter_specphot_std', ReportInput.RECIPE_INPUTS_OUTPUTS)
                         .with_dynamic_parameter('arm', which_arm)
                         .with_dynamic_parameter('jh', which_jh)
                         .with_dynamic_parameter('ifu', which_ifu)
                         .with_associated_input(bias, [master_bias_uvb], condition=is_UVB, min_ret=1,
                                                match_rules=associate_bias_cals)
                         .with_associated_input(bias, [master_bias_vis], condition=is_VIS, min_ret=1,
                                                match_rules=associate_bias_cals)
                         .with_alternative_associated_inputs(alternatives_flat)
                         .with_alternative_associated_inputs(alternatives_dmap)
                         .with_alternative_associated_inputs(alternatives_flex_nod)
                         .with_alternative_associated_inputs(alternatives_spectral_format)
                         .with_alternative_associated_inputs(alternatives_bp_map_rp)
                         .with_associated_input(atmos_ext)
                         .with_alternative_associated_inputs(alternatives_catalogs)
                         .with_associated_input(resp_fit_points_cat)
                         .with_associated_input(tell_mod_cat, min_ret=0)
                         .with_associated_input(sky_map_nir, min_ret=0, condition=is_NIR)
                         .with_associated_input(reference_response, min_ret=0)
                         .with_job_processing(fix_setup_keywords)
                         .with_input_filter(bp_map_nl_uvb, master_bias_uvb, order_tab_edges_slit_uvb,
                                            master_flat_slit_uvb, xsh_mod_cfg_opt_2d_uvb, DISP_TAB_UVB,
                                            order_tab_afc_slit_uvb, xsh_mod_cfg_opt_afc_uvb, disp_tab_afc_uvb,
                                            bp_map_rp_uvb_class, bp_map_nl_vis, master_bias_vis,
                                            order_tab_edges_slit_vis,
                                            master_flat_slit_vis, xsh_mod_cfg_opt_2d_vis, DISP_TAB_VIS,
                                            order_tab_afc_slit_vis, xsh_mod_cfg_opt_afc_vis, disp_tab_afc_vis,
                                            bp_map_rp_vis_class, bp_map_nl_nir, order_tab_edges_slit_nir,
                                            master_flat_slit_nir,
                                            xsh_mod_cfg_opt_2d_nir, DISP_TAB_NIR,
                                            order_tab_afc_slit_nir, xsh_mod_cfg_opt_afc_nir, disp_tab_afc_nir,
                                            bp_map_rp_nir_class, resp_fit_points_cat_uvb_class,
                                            resp_fit_points_cat_vis_class, resp_fit_points_cat_nir_class,
                                            spectral_format_tab_uvb_class, spectral_format_tab_vis_class,
                                            spectral_format_tab_nir_class, spectral_format_tab_nir_jh_class,
                                            atmos_ext_uvb_class, atmos_ext_vis_class, atmos_ext_nir_class,
                                            flux_std_catalog_uvb_class, flux_std_catalog_vis_class,
                                            flux_std_catalog_nir_class, reference_response_uvb_class,
                                            reference_response_vis_class,
                                            reference_response_nir_class,
                                            tell_mod_cat_vis_class, tell_mod_cat_nir_class)
                         .with_meta_targets([QC1_CALIB, response])
                         .build())
    # --- Select the response curve calibrations, depending on the workflow parameter response.
    # The mode in which standard stars were observed (nod, stare, or offset) is irrelevant, the match that is closer in
    # time is selected.
    # response: "night".  The response curve obtained from the standard star observed that night is used.
    #                     If not available, a standard within 1 week is searched. If not available,
    #                     then the master response is looked for.
    # response: "master". The master response curve downloaded with CalSelector is used. It is constructed by combining
    #                     the information of flux standards from several nights.
    # If no suitable response calibrations are found, the products will be not flux calibrated.

    response_calib = (alternative_associated_inputs(sort_keys=[kwd.mjd_obs])
                      .with_associated_input(response_slit_nod, [response_merge1d_slit_uvb],
                                             condition=lambda x: is_UVB_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_nod, [response_merge1d_slit_vis],
                                             condition=lambda x: is_VIS_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_nod, [response_merge1d_slit_nir],
                                             condition=lambda x: is_NIR_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_offset, [response_merge1d_slit_uvb],
                                             condition=lambda x: is_UVB_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_offset, [response_merge1d_slit_vis],
                                             condition=lambda x: is_VIS_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_offset, [response_merge1d_slit_nir],
                                             condition=lambda x: is_NIR_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_stare, [response_merge1d_slit_uvb],
                                             condition=lambda x: is_UVB_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_stare, [response_merge1d_slit_vis],
                                             condition=lambda x: is_VIS_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(response_slit_stare, [response_merge1d_slit_nir],
                                             condition=lambda x: is_NIR_slit(x) and use_night_response(x), min_ret=0)
                      .with_associated_input(mresponse_merge1d_slit, min_ret=0))

    return response_slit_offset, response_slit_stare, response_slit_nod, response_calib
