from edps import match

from . import xshooter_keywords as kwd


def is_xsh(f):
    return f[kwd.instrume] == 'XSHOOTER' or f[kwd.instrume] == 'SHOOT'


def is_calib(f):
    return is_xsh(f) and f[kwd.dpr_catg] == 'CALIB'


def is_science(f):
    return is_xsh(f) and f[kwd.dpr_catg] == 'SCIENCE'


def is_acquisition(f):
    return is_xsh(f) and f[kwd.dpr_catg] == 'ACQUISITION'


def is_uvb(f):
    return is_xsh(f) and f[kwd.seq_arm] == 'UVB'


def is_vis(f):
    return is_xsh(f) and f[kwd.seq_arm] == 'VIS'


def is_nir(f):
    return is_xsh(f) and f[kwd.seq_arm] == 'NIR'


def is_agc(f):
    return is_xsh(f) and (f[kwd.seq_arm] == 'AGC' or f[kwd.det_chip1_id] == 'CCD57-10IE')


def is_ifu(f):
    return is_xsh(f) and f[kwd.ins_opti2_id] == 'IFU'


def is_slit(f):
    return is_xsh(f) and f[kwd.ins_opti2_id] == 'SLOT'


def is_linearity_on(f):
    return is_calib(f) and f[kwd.dpr_type] == 'FLAT,LINEARITY,DETCHAR'


def is_image(f):
    return f[kwd.dpr_tech] == 'IMAGE'


def is_linearity_ir_off(f):
    return is_calib(f) and is_image(f) and f[kwd.dpr_type] == 'FLAT,LINEARITY,DETCHAR'


def is_linearity_opt_off(f):
    return is_calib(f) and f[kwd.dpr_type] in ['BIAS,LINEARITY,DETCHAR', 'BIAS,DETCHECK']


def is_linearity_on_uvb(f):
    return is_linearity_on(f) and is_uvb(f)


def is_linearity_on_vis(f):
    return is_linearity_on(f) and is_vis(f)


def is_linearity_on_nir(f):
    return is_linearity_on(f) and is_nir(f) and f[kwd.ins_lamp6_name] == 'NIR_FF_lamp'


def is_linearity_on_agc(f):
    return is_calib(f) and is_agc(f) and f[kwd.dpr_type] == 'FLAT,LINEARITY,DETCHAR'


def is_linearity_off_uvb(f):
    return is_linearity_opt_off(f) and is_uvb(f)


def is_linearity_off_vis(f):
    return is_linearity_opt_off(f) and is_vis(f)


def is_linearity_off_nir(f):
    return is_linearity_ir_off(f) and is_nir(f)


def is_linearity_off_agc(f):
    return is_linearity_opt_off(f) and is_agc(f)


def is_bias(f):
    return is_calib(f) and is_image(f) and f[kwd.dpr_type] == 'BIAS'


def is_bias_uvb(f):
    return is_bias(f) and is_uvb(f)


def is_bias_vis(f):
    return is_bias(f) and is_vis(f)


def is_bias_agc(f):
    return is_bias(f) and is_agc(f)


def is_dark(f):
    return is_calib(f) and is_image(f) and f[kwd.dpr_type] == 'DARK'


def is_dark_uvb(f):
    return is_dark(f) and is_uvb(f) and f[kwd.tpl_nexp] >= 3


def is_dark_vis(f):
    return is_dark(f) and is_vis(f) and f[kwd.tpl_nexp] >= 3


def is_dark_nir(f):
    return is_dark(f) and is_nir(f)


def is_dark_agc(f):
    return is_dark(f) and is_agc(f)


def is_thar_lamp(f):
    return f[kwd.ins_lamp1_name] == 'ThAr_Lamp'


def is_echelle(f):
    return f[kwd.dpr_tech] == 'ECHELLE'


def is_echelle_pinhole(f):
    return f[kwd.dpr_tech] == 'ECHELLE,PINHOLE'


def is_echelle_multi_pinhole(f):
    return f[kwd.dpr_tech] == 'ECHELLE,MULTI-PINHOLE'


def is_echelle_ifu_nodding(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU,NODDING'


def is_echelle_slit_stare(f):
    return f[kwd.dpr_tech] == 'ECHELLE,SLIT,STARE'


def is_echelle_slit_nodding(f):
    return f[kwd.dpr_tech] == 'ECHELLE,SLIT,NODDING'


def is_echelle_slit_offset(f):
    return f[kwd.dpr_tech] == 'ECHELLE,SLIT,OFFSET'


def is_echelle_slit_mapping(f):
    return f[kwd.dpr_tech] == 'ECHELLE,SLIT,MAPPING'


def is_echelle_ifu_mapping(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU,MAPPING'


def is_echelle_slit(f):
    return f[kwd.dpr_tech] == 'ECHELLE,SLIT'


def is_echelle_ifu(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU'


def is_echelle_ifu_offset(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU,OFFSET'


def is_echelle_ifu_stare(f):
    return f[kwd.dpr_tech] == 'ECHELLE,IFU,STARE'


def is_echelle_slit_on(f):
    return is_slit(f) and is_echelle_slit(f)


def is_echelle_slit_off(f):
    return is_slit(f) and is_image(f)


def is_echelle_ifu_on(f):
    return is_ifu(f) and is_echelle_ifu(f)


def is_echelle_ifu_off(f):
    return is_ifu(f) and is_image(f)


def is_lamp_fmtchk(f):
    return f[kwd.dpr_type] == 'LAMP,FMTCHK'


def is_lamp_orderdef(f):
    return f[kwd.dpr_type] == 'LAMP,ORDERDEF'


def is_lamp_afc(f):
    return f[kwd.dpr_type] == 'LAMP,AFC'


def is_calib_uvb(f):
    return is_calib(f) and is_uvb(f)


def is_calib_vis(f):
    return is_calib(f) and is_vis(f)


def is_calib_nir(f):
    return is_calib(f) and is_nir(f)


def is_fmtchk_uvb(f):
    return is_calib_uvb(f) and is_echelle_pinhole(f) and is_thar_lamp(f) and is_lamp_fmtchk(f)


def is_fmtchk_vis(f):
    return is_calib_vis(f) and is_echelle_pinhole(f) and is_thar_lamp(f) and is_lamp_fmtchk(f)


def is_fmtchk_on_nir(f):
    return is_calib_nir(f) and is_echelle_pinhole(f) and is_lamp_fmtchk(f) and \
        (f[kwd.ins_lamp2_name] == 'ArHgNeXe_Lamp' or f[kwd.ins_lamp2_name] == 'ArKrNeXe_Lamp') and f[
            kwd.det_dit] > 0.67


def is_fmtchk_off_nir(f):
    return is_calib_nir(f) and is_image(f) and is_lamp_fmtchk(f) and f[kwd.det_dit] > 0.67


def is_vis_ff_lamp(f):
    return f[kwd.ins_lamp5_name] == 'VIS_FF_lamp'


def is_opti3_pin_05(f):
    return f[kwd.ins_opti3_name] == 'Pin_0.5'


def is_opti4_pin_05(f):
    return f[kwd.ins_opti4_name] == 'Pin_0.5'


def is_opti5_pin_05(f):
    return f[kwd.ins_opti5_name] == 'Pin_0.5'


def is_orderdef(f):
    return is_calib(f) and is_lamp_orderdef(f) and is_echelle_pinhole(f)


def is_orderdef_off(f):
    return is_calib(f) and is_image(f) and is_lamp_orderdef(f)


def is_dorderdef_uvb(f):
    return is_calib_uvb(f) and f[kwd.dpr_type] == 'LAMP,DORDERDEF' and is_echelle_pinhole(f) and \
        f[kwd.det_binx] == 1 and f[kwd.det_biny] == 1 and is_opti3_pin_05(f)


def is_qorderdef_uvb(f):
    return is_calib_uvb(f) and f[kwd.dpr_type] == 'LAMP,QORDERDEF' and is_echelle_pinhole(f) and \
        f[kwd.det_binx] == 1 and f[kwd.det_biny] == 1 and is_opti3_pin_05(f) and \
        f[kwd.ins_lamp4_name] == 'UVB_High'


def is_orderdef_vis(f):
    return is_orderdef(f) and is_vis(f) and f[kwd.ins_lamp5_name] == 'VIS_FF_lamp' and \
        f[kwd.det_binx] == 1 and f[kwd.det_biny] == 1 and is_opti4_pin_05(f)


def is_orderdef_nir(f):
    return is_orderdef(f) and is_nir(f) and f[kwd.ins_lamp6_name] == 'NIR_FF_lamp' and is_opti5_pin_05(f)


def is_orderdef_nir_off(f):
    return is_orderdef_off(f) and is_nir(f) and is_opti5_pin_05(f)


def is_lamp_flat(f):
    return f[kwd.dpr_type] == 'LAMP,FLAT'


def is_skyflat_agc(f):
    return is_xsh(f) and f[kwd.dpr_type] == "FLAT,SKY" and f[kwd.dpr_catg] == "CALIB" and f[kwd.dpr_tech] == "IMAGE" and \
        f[kwd.det_chip1_name] == "E2V57IE"


def is_lamp_dflat(f):
    return f[kwd.dpr_type] == 'LAMP,DFLAT'


def is_lamp_qflat(f):
    return f[kwd.dpr_type] == 'LAMP,QFLAT'


def is_flat_slit(f):
    return is_calib(f) and is_vis_ff_lamp(f) and is_echelle_slit_on(f) and is_lamp_flat(f)


def is_flat_d2_slit_uvb(f):
    return is_calib_uvb(f) and is_echelle_slit_on(f) and is_lamp_dflat(f) and \
        f[kwd.ins_lamp3_name] == 'UVB_Low_D2'


def is_flat_qth_slit_uvb(f):
    return is_calib_uvb(f) and is_echelle_slit_on(f) and is_lamp_qflat(f) and \
        f[kwd.ins_lamp4_name] == 'UVB_High'


def is_flat_slit_vis(f):
    return is_calib_vis(f) and is_echelle_slit_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp5_name] == 'VIS_FF_lamp'


def is_flat_slit_nir_on(f):
    return is_calib_nir(f) and is_echelle_slit_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp6_name] == 'NIR_FF_lamp'


def is_flat_slit_nir_off(f):
    return is_calib_nir(f) and is_echelle_slit_off(f) and is_lamp_flat(f)


def is_flat_d2_ifu_uvb(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_dflat(f) and \
        f[kwd.ins_lamp3_name] == 'UVB_Low_D2' and f[kwd.tpl_nexp] > 2


def is_flat_qth_ifu_uvb(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_qflat(f) and \
        f[kwd.ins_lamp4_name] == 'UVB_High' and f[kwd.tpl_nexp] > 2


def is_flat_d2_ifu_uvb_hc(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_dflat(f) and \
        f[kwd.ins_lamp3_name] == 'UVB_Low_D2' and f[kwd.tpl_nexp] < 3


def is_flat_qth_ifu_uvb_hc(f):
    return is_calib_uvb(f) and is_echelle_ifu_on(f) and is_lamp_qflat(f) and \
        f[kwd.ins_lamp4_name] == 'UVB_High' and f[kwd.tpl_nexp] < 3


def is_flat_ifu_vis(f):
    return is_calib_vis(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp5_name] == 'VIS_FF_lamp' and f[kwd.tpl_nexp] > 1


def is_flat_ifu_vis_hc(f):
    return is_calib_vis(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp5_name] == 'VIS_FF_lamp' and f[kwd.tpl_nexp] < 2


def is_flat_ifu_nir_on(f):
    return is_calib_nir(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp6_name] == 'NIR_FF_lamp' and f[kwd.tpl_nexp] > 2


def is_flat_ifu_nir_off(f):
    return is_calib_nir(f) and is_echelle_ifu_off(f) and is_lamp_flat(f) and f[kwd.tpl_nexp] > 2


def is_flat_ifu_nir_on_hc(f):
    return is_calib_nir(f) and is_echelle_ifu_on(f) and is_lamp_flat(f) and \
        f[kwd.ins_lamp6_name] == 'NIR_FF_lamp' and f[kwd.tpl_nexp] < 3


def is_flat_ifu_nir_off_hc(f):
    return is_calib_nir(f) and is_echelle_ifu_off(f) and is_lamp_flat(f) and f[kwd.tpl_nexp] < 3


def is_lamp_wave(f):
    return is_calib(f) and f[kwd.dpr_type] == 'LAMP,WAVE'


def is_multi_pinhole(f):
    return is_lamp_wave(f) and is_echelle_multi_pinhole(f)  # and is_thar_lamp(f)


def is_wave_uvb(f):
    return is_multi_pinhole(f) and is_uvb(f)


def is_wave_vis(f):
    return is_multi_pinhole(f) and is_vis(f)


def is_wave_nir_on(f):
    return is_multi_pinhole(f) and is_nir(f) and is_echelle_multi_pinhole(f)


def is_wave_nir_off(f):
    return is_lamp_wave(f) and is_nir(f) and is_image(f) and f[kwd.ins_opti5_name] == 'Pin_row'


def is_wave_uvb_ifu(f):
    return is_lamp_wave(f) and is_echelle_ifu_on(f) and is_uvb(f)


def is_wave_vis_ifu(f):
    return is_lamp_wave(f) and is_echelle_ifu_on(f) and is_vis(f)


def is_wave_nir_on_ifu(f):
    return is_lamp_wave(f) and is_echelle_ifu_on(f) and is_nir(f)


def is_wave_nir_off_ifu(f):
    return is_lamp_wave(f) and is_nir(f) and is_image(f) and is_ifu(f)


def is_arc_slit_on(f):
    return is_lamp_wave(f) and is_echelle_slit_on(f) and is_thar_lamp(f)


def is_arc_slit_off(f):
    return is_lamp_wave(f) and is_echelle_slit_off(f) and is_thar_lamp(f)


def is_arc_ifu_on(f):
    return is_lamp_wave(f) and is_echelle_ifu_on(f) and is_thar_lamp(f)


def is_arc_ifu_off(f):
    return is_lamp_wave(f) and is_echelle_ifu_off(f) and is_thar_lamp(f)


def is_arc_slit_uvb(f):
    return is_arc_slit_on(f) and is_uvb(f)


def is_arc_slit_vis(f):
    return is_arc_slit_on(f) and is_vis(f)


def is_arc_slit_nir_on(f):
    return is_nir(f) and is_lamp_wave(f) and is_echelle_slit_on(f) and f[kwd.ins_lamp2_name] == 'ArHgNeXe_Lamp'


def is_arc_slit_nir_off(f):
    return is_nir(f) and is_lamp_wave(f) and is_echelle_slit_off(f) and f[kwd.ins_opti5_name] != 'Pin_row'


def is_arc_ifu_uvb(f):
    return is_arc_ifu_on(f) and is_uvb(f)


def is_arc_ifu_vis(f):
    return is_arc_ifu_on(f) and is_vis(f)


def is_arc_ifu_nir_on(f):
    return is_lamp_wave(f) and is_echelle_ifu_on(f) and is_nir(f) and f[kwd.ins_lamp2_name] == 'ArHgNeXe_Lamp'


def is_arc_ifu_nir_off(f):
    return is_lamp_wave(f) and is_echelle_ifu_off(f) and is_nir(f)


def is_afc_slit(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and f[kwd.ins_opti2_name] != 'SLOT' and \
        f[kwd.ins_opti4_name] != 'Pin_0.5' and f[kwd.tpl_id] in ['SHOOT_slt_acq', 'XSHOOTER_slt_acq',
                                                                 'SHOOT_slt_AFC', 'XSHOOTER_slt_AFC']


def is_afc_ifu(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and f[kwd.ins_opti2_name] != 'SLOT' and \
        f[kwd.ins_opti4_name] != 'Pin_0.5' and f[kwd.tpl_id] in ['SHOOT_ifu_acq', 'XSHOOTER_ifu_acq',
                                                                 'SHOOT_ifu_AFC', 'XSHOOTER_ifu_AFC']


def is_afc_generic(f):
    return (is_calib(f) and is_lamp_afc(f) and is_echelle(f) and f[kwd.tpl_id] in ['SHOOT_gen_cal_AFC', 'SHOOT_slt_AFC',
                                                                                   'XSHOOTER_slt_AFC',
                                                                                   'XSHOOTER_gen_cal_AFC'])


def is_adc_slit(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and f[kwd.ins_opti2_name] != "SLOT" and \
        f[kwd.tpl_id] in ["SHOOT_slt_acq", "XSHOOTER_slt_acq", "XSHOOTER_slt_acq_rrm"]


def is_adc_slit_uvb(f):
    return is_adc_slit(f) and is_uvb(f) and not is_opti3_pin_05(f)


def is_adc_slit_vis(f):
    return is_adc_slit(f) and is_vis(f) and not is_opti4_pin_05(f)


def is_adc_slit_nir(f):
    return is_adc_slit(f) and is_nir(f) and not is_opti5_pin_05(f)


def is_afc_slit_uvb(f):
    return is_afc_slit(f) and is_uvb(f)


def is_afc_slit_vis(f):
    return is_afc_slit(f) and is_vis(f)


def is_afc_slit_nir(f):
    return is_afc_slit(f) and is_nir(f)


def is_afc_ifu_uvb(f):
    return is_afc_ifu(f) and is_uvb(f)


def is_afc_ifu_vis(f):
    return is_afc_ifu(f) and is_vis(f)


def is_afc_ifu_nir(f):
    return is_afc_ifu(f) and is_nir(f)


def is_afc_generic_uvb(f):
    return is_afc_generic(f) and is_uvb(f)


def is_afc_generic_vis(f):
    return is_afc_generic(f) and is_vis(f)


def is_afc_generic_nir(f):
    return is_afc_generic(f) and is_nir(f)


def is_flex_slit(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and \
        f[kwd.ins_opti2_name] == 'SLOT' and \
        f[kwd.tpl_id] in ['SHOOT_slt_acq', 'XSHOOTER_slt_acq', 'XSHOOTER_slt_acq_rrm']


def is_flex_ifu(f):
    return is_calib(f) and is_lamp_afc(f) and is_echelle(f) and \
        f[kwd.ins_opti2_name] == 'SLOT' and \
        f[kwd.tpl_id] in ['SHOOT_ifu_acq', 'XSHOOTER_ifu_acq', 'XSHOOTER_ifu_acq_rrm']


def is_flex_slit_uvb(f):
    return is_flex_slit(f) and is_uvb(f) and is_opti3_pin_05(f)


def is_flex_slit_vis(f):
    return is_flex_slit(f) and is_vis(f) and is_opti4_pin_05(f)


def is_flex_slit_nir(f):
    return is_flex_slit(f) and is_nir(f) and is_opti5_pin_05(f)


def is_flex_ifu_uvb(f):
    return is_flex_ifu(f) and is_uvb(f) and is_opti3_pin_05(f)


def is_flex_ifu_vis(f):
    return is_flex_ifu(f) and is_vis(f) and is_opti4_pin_05(f)


def is_flex_ifu_nir(f):
    return is_flex_ifu(f) and is_nir(f) and is_opti5_pin_05(f)


def is_std_telluric(f):
    return f[kwd.dpr_type] == "STD,TELLURIC"


def is_std_tell_slit_stare(f):
    return is_calib(f) and is_std_telluric(f) and is_echelle_slit_stare(f) and \
        f[kwd.tpl_id] in ("SHOOT_slt_cal_TelluricStdStare", "XSHOOTER_slt_cal_TelluricStdStare")


def is_std_tell_slit_offset(f):
    return is_calib(f) and is_std_telluric(f) and is_echelle_slit_offset(f) and \
        f[kwd.tpl_id] in ("SHOOT_slt_cal_TelluricStdOff", "XSHOOTER_slt_cal_TelluricStdOff")


def is_std_tell_slit_nod(f):
    return is_calib(f) and is_std_telluric(f) and is_echelle_slit_nodding(f) and \
        (f[kwd.tpl_id] == 'SHOOT_slt_cal_TelluricStdNod' or f[kwd.tpl_id] == 'XSHOOTER_slt_cal_TelluricStdNod')


def is_std_tell_slit_stare_uvb(f):
    return is_std_tell_slit_stare(f) and is_uvb(f)


def is_std_tell_slit_stare_vis(f):
    return is_std_tell_slit_stare(f) and is_vis(f)


def is_std_tell_slit_stare_nir(f):
    return is_std_tell_slit_stare(f) and is_nir(f)


def is_std_tell_slit_offset_uvb(f):
    return is_std_tell_slit_offset(f) and is_uvb(f)


def is_std_tell_slit_offset_vis(f):
    return is_std_tell_slit_offset(f) and is_vis(f)


def is_std_tell_slit_offset_nir(f):
    return is_std_tell_slit_offset(f) and is_nir(f)


def is_std_tell_slit_nod_uvb(f):
    return is_std_tell_slit_nod(f) and is_uvb(f)


def is_std_tell_slit_nod_vis(f):
    return is_std_tell_slit_nod(f) and is_vis(f)


def is_std_tell_slit_nod_nir(f):
    return is_std_tell_slit_nod(f) and is_nir(f)


# Telluric IFU
def is_tell_ifu(f):
    return is_ifu(f) and is_std_telluric(f) and is_calib(f)


def is_tell_ifu_offset(f):
    return is_tell_ifu(f) and is_echelle_ifu_offset(f)


def is_tell_ifu_stare(f):
    return is_tell_ifu(f) and is_echelle_ifu_stare(f)


def is_tell_ifu_nod(f):
    return is_tell_ifu(f) and is_echelle_ifu_nodding(f)


def is_tell_ifu_offset_uvb(f):
    return is_tell_ifu_offset(f) and is_uvb(f)


def is_tell_ifu_offset_vis(f):
    return is_tell_ifu_offset(f) and is_vis(f)


def is_tell_ifu_offset_nir(f):
    return is_tell_ifu_offset(f) and is_nir(f)


def is_tell_ifu_stare_uvb(f):
    return is_tell_ifu_stare(f) and is_uvb(f)


def is_tell_ifu_stare_vis(f):
    return is_tell_ifu_stare(f) and is_vis(f)


def is_tell_ifu_stare_nir(f):
    return is_tell_ifu_stare(f) and is_nir(f)


def is_tell_ifu_nod_uvb(f):
    return is_tell_ifu_nod(f) and is_uvb(f)


def is_tell_ifu_nod_vis(f):
    return is_tell_ifu_nod(f) and is_vis(f)


def is_tell_ifu_nod_nir(f):
    return is_tell_ifu_nod(f) and is_nir(f)


def is_std_flux(f):
    return is_calib(f) and f[kwd.dpr_type] == 'STD,FLUX'


def is_std_sky(f):
    return is_calib(f) and f[kwd.dpr_type] == 'STD,SKY'


def is_std_flux_slit_stare(f):
    return is_std_flux(f) and is_echelle_slit_stare(f)


def is_std_flux_slit_stare_uvb(f):
    return is_std_flux_slit_stare(f) and is_calib_uvb(f)


def is_std_flux_slit_stare_vis(f):
    return is_std_flux_slit_stare(f) and is_calib_vis(f)


def is_std_flux_slit_stare_nir(f):
    return is_std_flux_slit_stare(f) and is_calib_nir(f)


def is_std_flux_ifu_stare_uvb(f):
    return is_std_flux(f) and is_uvb(f) and is_echelle_ifu_stare(f)


def is_std_flux_ifu_stare_vis(f):
    return is_std_flux(f) and is_vis(f) and is_echelle_ifu_stare(f)


def is_std_flux_ifu_stare_nir(f):
    return is_std_flux(f) and is_nir(f) and is_echelle_ifu_stare(f)


def is_std_flux_ifu_off_uvb(f):
    return is_std_flux(f) and is_uvb(f) and is_echelle_ifu_offset(f)


def is_std_flux_ifu_off_vis(f):
    return is_std_flux(f) and is_vis(f) and is_echelle_ifu_offset(f)


def is_std_flux_ifu_off_nir(f):
    return is_std_flux(f) and is_nir(f) and is_echelle_ifu_offset(f)


def is_sky_flux_ifu_off(f):
    return is_std_sky(f) and is_echelle_ifu_offset(f)


def is_sky_flux_ifu_off_uvb(f):
    return is_uvb(f) and is_sky_flux_ifu_off(f)


def is_sky_flux_ifu_off_vis(f):
    return is_vis(f) and is_sky_flux_ifu_off(f)


def is_sky_flux_ifu_off_nir(f):
    return is_nir(f) and is_sky_flux_ifu_off(f)


def is_std_flux_ifu_nod_uvb(f):
    return is_std_flux(f) and is_uvb(f) and is_echelle_ifu_nodding(f)


def is_std_flux_ifu_nod_vis(f):
    return is_std_flux(f) and is_vis(f) and is_echelle_ifu_nodding(f)


def is_std_flux_ifu_nod_nir(f):
    return is_std_flux(f) and is_nir(f) and is_echelle_ifu_nodding(f)


def is_std_flux_slit_nod(f):
    return is_std_flux(f) and is_echelle_slit_nodding(f)


def is_std_flux_slit_nod_uvb(f):
    return is_calib(f) and is_std_flux_slit_nod(f) and is_uvb(f)


def is_std_flux_slit_nod_vis(f):
    return is_calib(f) and is_std_flux_slit_nod(f) and is_vis(f)


def is_std_flux_slit_nod_nir(f):
    return is_calib(f) and is_std_flux_slit_nod(f) and is_nir(f)


def is_std_flux_slit_off(f):
    return is_std_flux(f) and is_echelle_slit_offset(f)


def is_std_flux_slit_off_uvb(f):
    return is_std_flux_slit_off(f) and is_uvb(f)


def is_std_flux_slit_off_vis(f):
    return is_std_flux_slit_off(f) and is_vis(f)


def is_std_flux_slit_off_nir(f):
    return is_std_flux_slit_off(f) and is_nir(f)


def is_sky_flux_slit_off(f):
    return is_std_sky(f) and is_echelle_slit_offset(f)


def is_sky_flux_slit_off_uvb(f):
    return is_sky_flux_slit_off(f) and is_uvb(f)


def is_sky_flux_slit_off_vis(f):
    return is_sky_flux_slit_off(f) and is_vis(f)


def is_sky_flux_slit_off_nir(f):
    return is_sky_flux_slit_off(f) and is_nir(f)


def is_std_tell_slit_off(f):
    return is_calib(f) and (is_std_telluric(f) or is_std_sky(f)) and is_echelle_slit_offset(f) and \
        (f[kwd.tpl_id] == 'SHOOT_slt_cal_TelluricStdOffset' or f[kwd.tpl_id] == 'XSHOOTER_slt_cal_TelluricStdOffset')


def is_std_tell_slit_off_uvb(f):
    return is_std_tell_slit_off(f) and is_uvb(f)


def is_std_tell_slit_off_vis(f):
    return is_std_tell_slit_off(f) and is_vis(f)


def is_std_tell_slit_off_nir(f):
    return is_std_tell_slit_off(f) and is_nir(f)


def is_object(f):
    return f[kwd.dpr_type] == 'OBJECT'


def is_sky(f):
    return f[kwd.dpr_type] == 'SKY'


def is_sci_slit_stare(f):
    return is_science(f) and (is_object(f) and (is_echelle_slit_stare(f) or is_echelle_slit_mapping(f))) \
        or (is_sky(f) and (is_echelle_slit_stare(f) or is_echelle_slit_mapping(f)))


def is_sci_slit_stare_uvb(f):
    return is_sci_slit_stare(f) and is_uvb(f)


def is_sci_slit_stare_vis(f):
    return is_sci_slit_stare(f) and is_vis(f)


def is_sci_slit_stare_nir(f):
    return is_sci_slit_stare(f) and is_nir(f)


def is_sci_slit_off(f):
    return is_science(f) and is_object(f) and is_echelle_slit_offset(f)


def is_sci_slit_off_uvb(f):
    return is_sci_slit_off(f) and is_uvb(f)


def is_sci_slit_off_vis(f):
    return is_sci_slit_off(f) and is_vis(f)


def is_sci_slit_off_nir(f):
    return is_sci_slit_off(f) and is_nir(f)


def is_sci_slit_nod(f):
    return is_science(f) and is_object(f) and is_echelle_slit_nodding(f)


def is_sci_slit_nod_uvb(f):
    return is_sci_slit_nod(f) and is_uvb(f)


def is_sci_slit_nod_vis(f):
    return is_sci_slit_nod(f) and is_vis(f)


def is_sci_slit_nod_nir(f):
    return is_sci_slit_nod(f) and is_nir(f)


def is_sky_slit_off(f):
    return is_science(f) and is_sky(f) and is_echelle_slit_offset(f)


def is_sky_slit_off_uvb(f):
    return is_sky_slit_off(f) and is_uvb(f)


def is_sky_slit_off_vis(f):
    return is_sky_slit_off(f) and is_vis(f)


def is_sky_slit_off_nir(f):
    return is_sky_slit_off(f) and is_nir(f)


def is_science_uvb(f):
    return is_science(f) and is_uvb(f)


def is_science_vis(f):
    return is_science(f) and is_vis(f)


def is_science_nir(f):
    return is_science(f) and is_nir(f)


def is_sci_ifu_stare_uvb(f):
    return is_science_uvb(f) and is_object(f) and (is_echelle_ifu_stare(f) or is_echelle_ifu_mapping(f))


def is_sci_ifu_stare_vis(f):
    return is_science_vis(f) and is_object(f) and (is_echelle_ifu_stare(f) or is_echelle_ifu_mapping(f))


def is_sci_ifu_stare_nir(f):
    return is_science_nir(f) and is_object(f) and (is_echelle_ifu_stare(f) or is_echelle_ifu_mapping(f))


def is_sci_ifu_nod_uvb(f):
    return is_science_uvb(f) and is_object(f) and is_echelle_ifu_nodding(f)


def is_sci_ifu_nod_vis(f):
    return is_science_vis(f) and is_object(f) and is_echelle_ifu_nodding(f)


def is_sci_ifu_nod_nir(f):
    return is_science_nir(f) and is_object(f) and is_echelle_ifu_nodding(f)


def is_sci_ifu_off_uvb(f):
    return is_science_uvb(f) and is_object(f) and is_echelle_ifu_offset(f)


def is_sci_ifu_off_vis(f):
    return is_science_vis(f) and is_object(f) and is_echelle_ifu_offset(f)


def is_sci_ifu_off_nir(f):
    return is_science_nir(f) and is_object(f) and is_echelle_ifu_offset(f)


def is_sky_ifu_off_uvb(f):
    return is_science_uvb(f) and is_sky(f) and is_echelle_ifu_offset(f)


def is_sky_ifu_off_vis(f):
    return is_science_vis(f) and is_sky(f) and is_echelle_ifu_offset(f)


def is_sky_ifu_off_nir(f):
    return is_science_nir(f) and is_sky(f) and is_echelle_ifu_offset(f)


def is_sky_ifu_map_uvb(f):
    return is_science_uvb(f) and is_sky(f) and is_echelle_ifu_mapping(f)


def is_sky_ifu_map_vis(f):
    return is_science_vis(f) and is_sky(f) and is_echelle_ifu_mapping(f)


def is_sky_ifu_map_nir(f):
    return is_science_nir(f) and is_sky(f) and is_echelle_ifu_mapping(f)


# ASSOCIATION RULES
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)

def match_nir_flat_to_dmap(ref, f):
    return match(ref, f, [kwd.det_chip_id, kwd.seq_arm, kwd.ins_opti2_id]) and \
        f[kwd.ins_opti5_name] != '0.9x11JH' and f[kwd.ins_opti5_name] != '0.6x11JH'


def assoc_flat_to_flex_nir(ref, f):
    return match(ref, f, [kwd.det_chip_id, kwd.seq_arm, kwd.ins_opti2_id]) and \
        (('JH' in ref[kwd.ins_opti5_name] and 'JH' in f[kwd.ins_opti5_name]) or
         ('JH' not in ref[kwd.ins_opti5_name] and 'JH' not in f[kwd.ins_opti5_name]))


def associate_flex(ref, f):
    return (ref[kwd.ins_opti2_name] == f[kwd.ins_opti2_name] or
            (ref[kwd.ins_opti2_name] == 'IFU' and f[kwd.ins_opti2_name] == 'SLOT')) and \
        ref[kwd.seq_arm] == f[kwd.seq_arm] and \
        (ref[kwd.obs_id] == f[kwd.obs_id] or ref[kwd.obs_container_id] == f[kwd.obs_container_id])
