/*
 * This file is part of the ESO UVES Pipeline
 * Copyright (C) 2004,2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2011-12-02 14:15:28 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */
#ifndef XSH_BARYVEL_H
#define XSH_BARYVEL_H

#include <cpl.h>
#include <xsh_parameters.h>
#include <irplib_sdp_spectrum.h>

void
xsh_baryvel(const cpl_propertylist *raw_header,
         double *barycor,
         double *helicor);

double xsh_baryvel_get_correction_factor(
        cpl_propertylist* keys, xsh_bary_corr_param* bary_corr_param);

#ifdef XSH_UNUSED
cpl_error_code xsh_baryvel_correct_irplib_spectrum(irplib_sdp_spectrum* self,
                                     xsh_bary_corr_param* bary_corr_param,
                                     cpl_parameterlist* keys);
#endif

cpl_error_code
xsh_baryvel_adjust_header(cpl_propertylist * header,
                          const char * keyword, double barycorr);

cpl_error_code
xsh_baryvel_set_specsys(cpl_propertylist * header,
                        xsh_bary_corr_param* bary_param);

cpl_error_code xsh_baryvel_correct_header(cpl_propertylist * header,
                                          cpl_propertylist * bary_header,
                                          xsh_bary_corr_param * bary_param);

double xsh_baryvel_correct_value(double value, double correction);

#endif  /* XSH_BARYVEL_H */
