/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include "mf_configuration.h"

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Functions
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 * @defgroup mf_configuration       Default parameters of telluriccorr.
 *
 * @brief
 *
 */
/*----------------------------------------------------------------------------*/

/**@{*/

/* ---------------------------------------------------------------------------*/
/**
 * @brief Return a structure with the default parameters of telluriccorr.
 *
 * @return mf_configuration  Structure with the default parameters .
 *
 */
/* ---------------------------------------------------------------------------*/
mf_configuration * mf_configuration_create(void)
{
  mf_configuration *config = cpl_malloc(sizeof(mf_configuration));

  config->parameters = mf_parameters_config_create();
  config->lblrtm     = mf_lblrtm_config_create();
  config->lnfl       = mf_lnfl_config_create();

  return config;
}

/* ---------------------------------------------------------------------------*/
/**
 * @brief Delete mf_configuration structure.
 *
 * @param config             Telluric correction configuration
 *
 */
/* ---------------------------------------------------------------------------*/
void mf_configuration_delete(
    mf_configuration         *config)
{
  if (config) {

      if (config->parameters) mf_parameters_config_delete(config->parameters);
      if (config->lblrtm    ) mf_lblrtm_config_delete(    config->lblrtm    );
      if (config->lnfl      ) mf_lnfl_config_delete(      config->lnfl      );

      cpl_free(config);
  }
}

/** @cond PRIVATE */

/** @endcond */


/**@}*/
