# SPDX-License-Identifier: BSD-3-Clause
# from matplotlib.figure import Figure
# from matplotlib.backends.backend_qtagg import FigureCanvas
# from matplotlib.backends.backend_agg import FigureCanvas
from adari_core.server.server_base import AdariServerBase
from adari_core.backends.json import JSONRenderer

# from adari_core.backends.matplotlib import MatplotlibRenderer


class AdariServerJSON(AdariServerBase):
    """
    ADARI Server that produces JSON files and does not support interactivity.

    Parameters
    ----------
    renderer_config: map
        The configuration of the matplotlib renderer.
    """

    def __init__(self, renderer_config: map, uds=None):
        super().__init__(uds)
        self.renderer_config = renderer_config
        self.drivers_list.append("json")
        self.renderer = JSONRenderer()
