# adari_core

ADARI (Astronomical DAta Reporting Infrastructure) is a software created by ESO that is used to create reports (either static artifacts or interactive) that show different astronomical data produced by ESO instruments and pipelines.

ADARI has two components: adari_core and adari_datalibs. For the time being the second one is included within the same adari_core repo, but this might change in the future.

## Get the code

```
git clone https://gitlab.eso.org/pipelines/common/adari_core.git

```
Or if you have configured SSH keys in gitlab.eso.org:
```
git clone git@gitlab.eso.org:pipelines/common/adari_core.git

```

## Building ADARI

To create an ADARI package you need to have installed at least the python build package. If you have either venv or virtualenv packages installed then this command will create an installable python wheel if run in the top level directory : 
```
$ python -m build .
```
That will create a virtual environment that will install the packages needed to create the package.

Alternatively, if you have the wheel and setuptools packages in your current python installation you can use this command, which will use those packages rather than installing them in a virtual environment:
```
$ python -m build -n .
```
This creates a python wheel in the _dist_ subdirectory. 

If you have a Debian/Ubuntu system you can install the packages needed both for package creation and installation of ADARI itself with this command:
```
$ apt install python3-build python3-venv python3-wheel python3-matplotlib python3-pydantic python3-fastapi python3-requests python3-requests-unixsocket python3-uvicorn python3-astropy
```

If you have a Fedora system you can install the packages needed both for package creation and installation of ADARI itself with this command:
```
$ dnf -y install python3-build python3-wheel python3-matplotlib python3-requests python3-requests-unixsocket python3-pydantic python3-fastapi python3-uvicorn python3-astropy 
```

## Installing ADARI

Installing the wheel created in the previous step can be done using pip. You can create a virtual environment to install the wheel or install it in your HOME. Also, optionally the virtual environment can use the system packages installed in previous step or not.

To create the virtual environment use:
```
$ python3 -m venv inst_venv
```

If you want to use the python system packages:
```
$ python3 -m venv --system-site-packages inst_venv
```

To install the wheel:
```
$ pip install dist/adari_core*whl
```

## Running  reports

To run reports, use the genreport command:
```
genreport -i recipe_inputs.sof -o out.json -d png espresso_orderdef
```

Where espresso_orderdef is the name of the report.

### genreport command

This is the  man page of the genreport command:

```
NAME
      genreport - Run reports of ESO instrument data and products

SYNOPSIS
       genreport [OPTION]... [REPORT]...

DESCRIPTION
        genreport runs the named report which will be fed with input files and will produce
        static report files (png, pdf) and/or visualizations for a given backend.

OPTIONS
        -i, --inputs=sof Input files to be used by the report. The format of the "sof" file is the 
                        same as for esorex: a list of files with a category as shown here:
                        IIINSTRUMENT.2019-08-25T11:25:26.917.fits DARK_RAW
                        IIINSTRUMENT.2019-08-25T11:25:28.111.fits DARK_RAW
                        IIINSTRUMENT_MASTER_BIAS                  MASTER_BIAS
        -d, --driver=driver Specify the plotting driver to use. Possibe options are "png",
                            "json", "pdf", "mpl" (for interactive matplotlib) and "bokeh"
                            (for interactive web applications). It is possible to send a 
                            list of drivers.
        -o, --outputs=report_output.json genreport will write in out.json the artifacts that 
                                         have been generated by the report as well as the 
                                         metadata associated to the artifacts.
        -l, --log-file=file.log Output file with logs of the report programm.


EXIT STATUS
        0   If execution was successful
        1   If the execution of the report has caused and exception or has crashed
        2   If the ADARI Report Server cannot be contacted and/or started. 
        3   If the ADARI Report Server does not support the given driver. 
```
                      
                        
