"""
ADARI logging utilities.

This module is a placeholder, to allow for the possible centralization
of logging configuration in the future. For now, all files within ADARI
should create and use their own name-based logger::

  import logging
  logger = logging.getLogger(__name__)

"""

import logging

# Get the master logger created in adari_core.__init__
ADARI_MASTER_LOGGER = logging.getLogger("adari_core")
ADARI_MASTER_LOGGER.debug(
    f"Grabbed ADARI_MASTER_LOGGER, logging level " f"{ADARI_MASTER_LOGGER.level}"
)


def getLogger():
    """
    This is a convenience function for returning the ADARI master logger.
    This is so formatters & handlers can be applied to it.

    Returns
    -------
    The ADARI master logger (:any:`ADARI_MASTER_LOGGER`).
    """

    return ADARI_MASTER_LOGGER
