# SPDX-License-Identifier: BSD-3-Clause

from .matplotlib import MatplotlibRenderer


def get_renderer(backend):
    """
    Retrieve a Renderer object for the specified backend

    :param backend:
    :return:
    """

    if backend is None:
        raise ValueError("You must supply a backend name.")
    #    elif backend == "bokeh":
    #        return BokehRenderer()
    elif backend == "matplotlib":
        return MatplotlibRenderer()
    else:
        raise NotImplementedError("Backend %s not available", backend)
