# SPDX-License-Identifier: BSD-3-Clause

# from matplotlib.backends.backend_qtagg import FigureCanvas
# from matplotlib.backends.backend_agg import FigureCanvas
from adari_core.server.server_base import AdariServerBase
from adari_core.backends.matplotlib import MatplotlibRenderer


class AdariServerPng(AdariServerBase):
    """
    ADARI Server that produces PNG files and does not support interactivity.
    Currently this is implemented using the matplotib renderer

    Parameters
    ----------
    renderer_config: map
        The configuration of the matplotlib renderer.
    """

    def __init__(self, renderer_config: map, uds=None):
        super().__init__(uds)
        self.renderer_config = renderer_config
        self.renderer_config["mpl_savefig_format"] = "png"
        self.drivers_list.append("png")
        self.renderer = MatplotlibRenderer(self.renderer_config, mpl_backend="Agg")
        self.report_figure = {}
        self.report_canvas = {}
