from typing import List, Optional, Dict

from pydantic import BaseModel

from edps.client.RequestParameters import RequestParameters


class CalselectorRequest(BaseModel):
    workflow: str
    inputs: List[Dict]
    targets: Optional[List[str]] = None
    meta_targets: Optional[List[str]] = None
    parameters: RequestParameters = RequestParameters()

    def __repr__(self):
        return self.model_dump_json()

    class Config:
        json_schema_extra = {
            "example": {
                "workflow": "espresso.espresso_wkf",
                "inputs": [{"instrume": "ESPRESSO", "dpr.catg": "SCIENCE", "dpr.type": "OBJECT,SKY"}],
                "targets": ["science"],
                "meta_targets": ["calselector"],
                "parameters": RequestParameters.Config.json_schema_extra['example']
            }
        }
