from typing import Dict

from pydantic import BaseModel


class ParameterSetDTO(BaseModel):
    name: str
    default: bool
    recipe_parameters: Dict[str, Dict[str, str]]
    workflow_parameters: Dict[str, str]
    parameter_metadata: Dict[str, str]

    class Config:
        json_schema_extra = {
            "example": {
                "name": "default_parameters",
                "default": True,
                "recipe_parameters": {"task1": {"param1": "value1"}},
                "workflow_parameters": {"param1": "value1"},
                "parameter_metadata": {"param1": "description1"}
            }
        }
