from enum import Enum

from pydantic import BaseModel


class ProcessingJobStatus(str, Enum):
    CREATED = "CREATED"
    RUNNING = "RUNNING"
    COMPLETED = "COMPLETED"
    FAILED = "FAILED"
    MISSING = "MISSING"

    def __dict__(self):
        return {self.name: self.value}


class JobStatus(BaseModel):
    status: ProcessingJobStatus
    rejected: bool = False
    interrupted: bool = False

    @classmethod
    def from_dict(cls, d: dict) -> 'JobStatus':
        return cls(
            status=ProcessingJobStatus(d['status']),
            rejected=d.get('rejected', False),
            interrupted=d.get('interrupted', False)
        )
