from typing import List, Optional

from pydantic import BaseModel

from edps.client.ReportsConfiguration import ReportsConfiguration, ALL_REPORTS
from edps.client.RequestParameters import RequestParameters
from edps.generator.association_preference import AssociationPreference


class ProcessingRequest(BaseModel):
    workflow: Optional[str] = None
    inputs: List[str] = []
    excluded_inputs: List[str] = []
    targets: Optional[List[str]] = None
    meta_targets: Optional[List[str]] = None
    callback: Optional[str] = None
    parameters: RequestParameters = RequestParameters()
    breakpoint_tasks: List[str] = []
    association_preference: Optional[AssociationPreference] = None
    package_base_dir: Optional[str] = None
    renaming_prefix: Optional[str] = None
    reports_configuration: ReportsConfiguration = ALL_REPORTS

    def __repr__(self):
        return self.model_dump_json()

    class Config:
        json_schema_extra = {
            "example": {
                "workflow": "edps.workflow.fors_imaging_wkf",
                "inputs": ["/opt/calibfiles"],
                "excluded_inputs": ["/opt/calibfiles/excluded"],
                "targets": ["bias", "flat"],
                "meta_targets": ["calib"],
                "callback": "http://example.com",
                "parameters": RequestParameters.Config.json_schema_extra['example'],
                "breakpoint_tasks": ["bias"],
                "association_preference": "RAW",
                "package_base_dir": "/opt/outputs",
                "renaming_prefix": "QC0",
                "reports_configuration": ReportsConfiguration.Config.json_schema_extra['example']
            }
        }
