from typing import List

from pydantic import BaseModel

from .JobSummary import JobSummary


class ProcessingResponse(BaseModel):
    jobs: List[JobSummary] = []
    incomplete_jobs: List[JobSummary] = []
    files_with_no_jobs: List[str] = []
    incomplete_groups: List[List[str]] = []

    @classmethod
    def from_dict(cls, d):
        return cls(
            jobs=[JobSummary.from_dict(job) for job in d["jobs"]],
            incomplete_jobs=[JobSummary.from_dict(job) for job in d["incomplete_jobs"]],
            files_with_no_jobs=d["files_with_no_jobs"],
            incomplete_groups=d["incomplete_groups"]
        )

    def __repr__(self):
        return self.model_dump_json()

    class Config:
        json_schema_extra = {
            "example": {
                "jobs": [JobSummary.Config.json_schema_extra['example']],
                "incomplete_jobs": [JobSummary.Config.json_schema_extra['example']],
                "files_with_no_jobs": ["/path/to/file1.fits", "/path/to/file2.fits"],
                "incomplete_groups": [["/path/to/file3.fits", "/path/to/file4.fits"]]
            }
        }
