from pydantic import BaseModel
from typing import List

from edps import ReportInput


class ReportsConfiguration(BaseModel):
    task_names: List[str]
    report_types: List[ReportInput]

    def should_run(self, report_type: ReportInput, task_name: str) -> bool:
        return ("ALL" in self.task_names or task_name in self.task_names) and report_type in self.report_types

    class Config:
        json_schema_extra = {
            "example": {
                "task_names": ["BIAS", "FLAT"],
                "report_types": ["RECIPE_INPUTS"]
            }
        }


ALL_REPORTS = ReportsConfiguration(task_names=["ALL"], report_types=[ReportInput.RECIPE_INPUTS, ReportInput.RECIPE_OUTPUTS, ReportInput.RECIPE_INPUTS_OUTPUTS])
