from typing import Dict, Optional, Any

from pydantic import BaseModel


class RequestParameters(BaseModel):
    workflow_parameter_set: Optional[str] = None
    workflow_parameters: Dict[str, Any] = {}
    recipe_parameter_set: Optional[str] = None
    recipe_parameters: Dict[str, Dict[str, Any]] = {}

    def __repr__(self):
        return self.model_dump_json()

    @classmethod
    def from_dict(cls, d):
        return cls(
            workflow_parameter_set=d.get('workflow_parameter_set', None),
            workflow_parameters=d.get('workflow_parameters', {}),
            recipe_parameter_set=d.get('recipe_parameter_set', None),
            recipe_parameters=d.get('recipe_parameters', {})
        )

    class Config:
        json_schema_extra = {
            "example": {
                "workflow_parameter_set": "qc0_parameters",
                "workflow_parameters": {"molecfit": "standard"},
                "recipe_parameter_set": "qc0_parameters",
                "recipe_parameters": {"DARK": {"kmos.kmos_dark.cmin": "1"}}
            }
        }
