from typing import List

from pydantic import BaseModel

from edps import ReportInput


class RunReportsRequestDTO(BaseModel):
    job_ids: List[str]
    report_types: List[ReportInput] = [ReportInput.RECIPE_INPUTS, ReportInput.RECIPE_OUTPUTS, ReportInput.RECIPE_INPUTS_OUTPUTS]

    class Config:
        json_schema_extra = {
            "example": {
                "job_ids": ["5c04c6ce-5dd0-4a32-a9b8-41b55f66319c"],
                "report_types": [ReportInput.RECIPE_INPUTS, ReportInput.RECIPE_INPUTS_OUTPUTS],
            }
        }
