from typing import List

from pydantic import BaseModel

from .FitsFile import FitsFile


class DataSourceStateDTO(BaseModel):
    name: str
    files: List[FitsFile]

    @classmethod
    def from_dict(cls, d):
        return cls(name=d['name'], files=[FitsFile.from_dict(x) for x in d['files']])

    class Config:
        json_schema_extra = {
            "example": {
                "name": "BIAS",
                "files": [FitsFile.Config.json_schema_extra['example']],
            }
        }


class TaskStateDTO(BaseModel):
    name: str
    files: List[FitsFile]
    jobs: List[str]

    @classmethod
    def from_dict(cls, d):
        return cls(name=d['name'], files=[FitsFile.from_dict(x) for x in d['files']], jobs=d['jobs'])

    class Config:
        json_schema_extra = {
            "example": {
                "name": "bias",
                "files": [FitsFile.Config.json_schema_extra['example']],
                "jobs": ["5c04c6ce-5dd0-4a32-a9b8-41b55f66319c", "6c04c6ce-5dd0-4a32-a9b8-41b55f66319c"]
            }
        }


class WorkflowStateDTO(BaseModel):
    data_sources: List[DataSourceStateDTO]
    tasks: List[TaskStateDTO]

    @classmethod
    def from_dict(cls, d):
        return cls(data_sources=[DataSourceStateDTO.from_dict(x) for x in d['data_sources']],
                   tasks=[TaskStateDTO.from_dict(x) for x in d['tasks']])

    class Config:
        json_schema_extra = {
            "example": {
                "data_sources": [DataSourceStateDTO.Config.json_schema_extra['example']],
                "tasks": [TaskStateDTO.Config.json_schema_extra['example']]
            }
        }
