from typing import TypeVar, Generic

T = TypeVar('T')
E = TypeVar('E')


class Either(Generic[T, E]):
    def __init__(self, right: T, left: E = None):
        self.left = left
        self.right = right

    def is_right(self) -> bool:
        return self.right is not None

    def is_left(self) -> bool:
        return self.left is not None

    def get(self) -> T:
        return self.right

    def get_left(self) -> E:
        return self.left

    @staticmethod
    def right(val: T) -> 'Either[T,E]':
        return Either(right=val)

    @staticmethod
    def left(err: E) -> 'Either[T,E]':
        return Either(right=None, left=err)

    def __repr__(self) -> str:
        if self.is_left():
            return f"Left {self.get_left()}"
        else:
            return f"Right {self.get()}"
