import datetime
import sys
from dataclasses import dataclass
from typing import List, Optional


@dataclass
class SearchFilter:
    instrument: str = ".*"
    targets: Optional[List[str]] = None
    meta_targets: Optional[List[str]] = None
    completion_time_from: datetime.datetime = datetime.datetime.min
    completion_time_to: datetime.datetime = datetime.datetime.max
    mjdobs_from: float = 0
    mjdobs_to: float = sys.float_info.max
    submission_time_from: datetime.datetime = datetime.datetime.min
    submission_time_to: datetime.datetime = datetime.datetime.max

    def __str__(self):
        return f"""Search query for instrument {self.instrument}, targets {self.targets}, meta-targets {self.meta_targets}, 
        with mjd obs from {self.mjdobs_from} to {self.mjdobs_to},
        submitted from {self.submission_time_from} to {self.submission_time_to}.
         completed from {self.completion_time_from} to {self.completion_time_to}"""
