import os.path
import shutil
import uuid
from uuid import UUID

from edps.client.FitsFile import FitsFile
from edps.interfaces.JobsRepository import JobsRepository, ExecutionResult, JobDetails


class JobCloner:
    def __init__(self, repository: JobsRepository, base_dir: str):
        self.repository = repository
        self.base_dir = base_dir

    def clone_job(self, original_job_id: UUID, result: ExecutionResult) -> UUID:
        job_details = self.repository.get_job_details(original_job_id).clone()
        new_job_id = uuid.uuid4()
        src_dir = self.get_job_dir(job_details.configuration.instrument, job_details.configuration.task_name, str(original_job_id))
        target_dir = self.get_job_dir(job_details.configuration.instrument, job_details.configuration.task_name, str(new_job_id))
        shutil.copytree(src_dir, target_dir)
        job_details.configuration.job_id = str(new_job_id)
        new_result = ExecutionResult(
            result.status,
            result.input_files,
            [FitsFile(name=f.name.replace(str(original_job_id), str(new_job_id)), category=f.category) for f in result.output_files],
            result.logs,
            result.reports,
            result.recipe_parameters,
            result.completion_date
        )
        new_details = JobDetails(configuration=job_details.configuration, result=new_result, submission_date=job_details.submission_date)
        self.repository.insert_job(new_details)
        self.delete_all_files(src_dir)
        return new_job_id

    def get_job_dir(self, instrument: str, task_name: str, job_id: str):
        return os.path.join(self.base_dir, instrument, task_name, job_id)

    def delete_all_files(self, job_dir: str):
        for files in os.listdir(job_dir):
            path = os.path.join(job_dir, files)
            try:
                shutil.rmtree(path)
            except OSError:
                os.remove(path)
