from .recipe import RecipeInvocationArguments, RecipeInvocationResult, InvokerProvider
from .renamer import ProductRenamer


def copy_upstream(parameters: RecipeInvocationArguments, invoker_provider: InvokerProvider, renamer: ProductRenamer) -> RecipeInvocationResult:
    return RecipeInvocationResult(return_code=0, output_files=parameters.inputs.associated)


def copy_all(parameters: RecipeInvocationArguments, invoker_provider: InvokerProvider, renamer: ProductRenamer) -> RecipeInvocationResult:
    return RecipeInvocationResult(return_code=0, output_files=parameters.inputs.combined)


def empty(parameters: RecipeInvocationArguments, invoker_provider: InvokerProvider, renamer: ProductRenamer) -> RecipeInvocationResult:
    return RecipeInvocationResult(return_code=0, output_files=[])
