import logging
from typing import List, Dict

from edps.client.FitsFile import FitsFile

logger = logging.getLogger("SofWriter")


class SofWriter:

    @staticmethod
    def generate_sof(input_files: List[FitsFile], sof_path: str, log_prefix: str, category_mapping: Dict[str, str] = None) -> str:
        if category_mapping is None:
            category_mapping = {}
        logger.info("%s writing SOF %s", log_prefix, sof_path)
        with open(sof_path, 'wb') as sof_file:
            for input_file in input_files:
                file_category = category_mapping.get(input_file.category, input_file.category)
                if file_category != input_file.category:
                    logger.info("%s overriding category of file %s %s -> %s", log_prefix,
                                input_file.name, input_file.category, file_category)
                sof_file.write(f"{input_file.name} {file_category}\n".encode("utf-8"))
        return sof_path
