from enum import Enum


class AssociationPreference(str, Enum):
    RAW = "RAW"
    MASTER = "MASTER"
    RAW_PER_QUALITY_LEVEL = "RAW_PER_QUALITY_LEVEL"
    MASTER_PER_QUALITY_LEVEL = "MASTER_PER_QUALITY_LEVEL"

    @classmethod
    def from_str(cls, value: str):
        preference = value.lower()
        if preference == 'raw':
            return cls.RAW
        elif preference == 'master':
            return cls.MASTER
        elif preference == 'raw_per_quality_level':
            return cls.RAW_PER_QUALITY_LEVEL
        elif preference == 'master_per_quality_level':
            return cls.MASTER_PER_QUALITY_LEVEL
        else:
            raise ValueError(f"Invalid association preference {value}")
