from pathlib import Path
from typing import List, Set


class InputFilesResolver:
    def __init__(self, inputs: List[str], excluded_inputs: List[str]):
        self.suffixes = {'.fits', '.fz'}
        self.inputs = inputs
        self.excluded_inputs = excluded_inputs

    def resolve_inputs(self) -> List[Path]:
        excluded_paths = [Path(filename).resolve() for filename in self.excluded_inputs]
        excluded_dirs = set(path for path in excluded_paths if path.is_dir())
        excluded_files = set(path for path in excluded_paths if path.is_file())

        paths = [Path(filename).resolve() for filename in self.inputs]
        dir_paths = [path for path in paths if path.is_dir() and not self.in_excluded_dir(path, excluded_dirs)]
        recursive_paths = [file_path for dir_path in dir_paths for file_path in dir_path.rglob("*")]
        file_paths = [path for path in paths + recursive_paths if
                      path.is_file()
                      and path.suffix in self.suffixes
                      and path not in excluded_files
                      and not self.in_excluded_dir(path, excluded_dirs)]
        return list(set(file_paths))

    @staticmethod
    def in_excluded_dir(path: Path, excluded_dirs: Set[Path]) -> bool:
        return any(path.is_relative_to(x) for x in excluded_dirs)
