import logging
from typing import List, Dict, Generator

import networkx as nx

from edps.client.JobInfo import JobInfo


class JobInfoGraph:
    def __init__(self, jobs: List[JobInfo]):
        self.job_map: Dict[str, JobInfo] = {job.job_id: job for job in jobs}
        self.graph = self.create_graph()

    def create_graph(self) -> nx.DiGraph:
        graph = nx.DiGraph()
        for job in self.job_map.values():
            graph.add_node(job)
            for parent_id in job.parents_ids:
                if parent_id in self.job_map:
                    graph.add_edge(self.job_map[parent_id], job)
                else:
                    logging.error(f"Incomplete job graph. Missing parent '{parent_id}'")
        return graph

    def topological_sort(self) -> Generator[JobInfo, None, None]:
        return nx.topological_sort(self.graph)
