from typing import Callable

from edps.generator.task_builder import TaskBuilder, DataSourceBuilder


def subworkflow_task(original: Callable[[DataSourceBuilder, str], None], subworkflow_name: str, suffix: str = "") -> Callable[[DataSourceBuilder, str], None]:
    def inner_subworkflow_task(self: DataSourceBuilder, name: str) -> None:
        original(self, name + suffix)
        self.with_subworkflow_name(subworkflow_name)

    return inner_subworkflow_task


def subworkflow_data_source(original: Callable[[TaskBuilder, str], None], subworkflow_name: str, suffix: str = "") -> Callable[[TaskBuilder, str], None]:
    def inner_subworkflow_data_source(self: TaskBuilder, name: str = None) -> None:
        name = name + suffix if name else None
        original(self, name)
        self.with_subworkflow_name(subworkflow_name)

    return inner_subworkflow_data_source


def subworkflow(subworkflow_name: str, suffix: str):
    def decorator(func: Callable):
        def wrapper(*args, **kwargs):
            original_task_init = TaskBuilder.__init__
            original_datasource_init = DataSourceBuilder.__init__
            TaskBuilder.__init__ = subworkflow_task(original_task_init, subworkflow_name, suffix)
            DataSourceBuilder.__init__ = subworkflow_data_source(original_datasource_init, subworkflow_name, suffix)
            result = func(*args, **kwargs)
            TaskBuilder.__init__ = original_task_init
            DataSourceBuilder.__init__ = original_datasource_init
            return result

        return wrapper

    return decorator
