from dataclasses import dataclass
from enum import Enum
from typing import Dict, List, Callable

from edps.client.JobInfo import ReportConfigDTO
from .fits import ClassifiedFitsFile
from .parameters import JobParameters

ActiveCondition = Callable[[JobParameters], bool]
DynamicParameterProvider = Callable[[List[ClassifiedFitsFile]], object]


class CommandType(str, Enum):
    RECIPE = 'recipe'
    FUNCTION = 'function'
    SHELL = 'shell'


class FilterMode(str, Enum):
    SELECT = "SELECT"
    REJECT = "REJECT"


class ReportInput(str, Enum):
    RECIPE_INPUTS = "RECIPE_INPUTS"
    RECIPE_OUTPUTS = "RECIPE_OUTPUTS"
    RECIPE_INPUTS_OUTPUTS = "RECIPE_INPUTS_OUTPUTS"


@dataclass
class CommandConfig:
    command: str
    command_type: CommandType
    recipes: List[str]


@dataclass
class ReportConfig:
    name: str
    input: ReportInput
    driver: str

    def as_dto(self) -> ReportConfigDTO:
        return ReportConfigDTO(name=self.name, input=self.input.name, driver=self.driver)


@dataclass
class TaskDetails:
    task_id: str
    command: str
    command_type: CommandType
    task_name: str
    input_filter: List[str]
    input_filter_mode: FilterMode
    output_filter: List[str]
    output_filter_mode: FilterMode
    input_map: Dict[str, str]
    workflow_names: List[str]
    dynamic_parameters: Dict[str, DynamicParameterProvider]
    active_condition: ActiveCondition
    setup_keywords: List[str]
    reports: List[ReportConfig]
