import re
from typing import List

from .fits import ClassifiedFitsFile
from .parameters import JobParameters


def get_parameter(params: JobParameters, name: str) -> object:
    return params.get_workflow_param(name)


def match(ref: ClassifiedFitsFile, it: ClassifiedFitsFile, keywords: List[str]):
    return all([ref[kw] == it[kw] for kw in keywords])


def like(a, b):
    return a is not None and b is not None and re.match(b.replace('%', '.*'), a) is not None


def regexp(a, b):
    return a is not None and b is not None and re.match(b, a) is not None


def between(a, b, c):
    return b <= a <= c
