from typing import List, Set, Optional
from uuid import UUID

from edps.client.JobInfo import JobInfo
from edps.client.ReportsConfiguration import ReportsConfiguration
from edps.client.RunReportsRequestDTO import RunReportsRequestDTO
from edps.generator.constants import ParameterSetName


class JobExecutor(object):
    def execute(self, job_configurations: List[JobInfo], submission_date: str, package_base_dir: str, callback_url: str, targets: Optional[List[str]],
                renaming_prefix: Optional[str], reports_configuration: ReportsConfiguration, parameter_set_name: Optional[ParameterSetName]):
        raise NotImplementedError

    def run_reports(self, request: RunReportsRequestDTO) -> List[str]:
        raise NotImplementedError

    def get_job_file(self, job_id: UUID, filename: str) -> bytes:
        raise NotImplementedError

    def shutdown(self):
        raise NotImplementedError

    def any_scheduled(self, jobs_to_delete: Set[UUID]) -> bool:
        raise NotImplementedError

    def get_scheduled_jobs(self) -> List[UUID]:
        raise NotImplementedError

    def wait_until_nothing_scheduled(self):
        raise NotImplementedError
